/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pufferfish;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;

@Mixin(value={LivingEntityRenderer.class})
public abstract class MixinLivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    @Shadow
    protected M f_115290_;
    @Unique
    private M emf$heldModelToForce = null;

    protected MixinLivingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void emf$saveEMFModel(EntityRendererProvider.Context ctx, EntityModel<T> model, float shadowRadius, CallbackInfo ci) {
        if (this.f_115290_ != null && ((IEMFModel)this.f_115290_).emf$isEMFModel()) {
            this.emf$heldModelToForce = this.f_115290_;
        }
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", shift=At.Shift.BEFORE)})
    private void emf$Animate(T livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        EMFModelPartRoot root;
        if (this.emf$heldModelToForce != null) {
            if (!this.emf$heldModelToForce.equals(this.f_115290_) && !(livingEntity instanceof Pufferfish)) {
                boolean replace = EMFConfig.getConfig().attemptRevertingEntityModelsAlteredByAnotherMod && "minecraft".equals(EntityType.m_20613_((EntityType)livingEntity.m_6095_()).m_135827_());
                EMFUtils.EMFOverrideMessage(this.emf$heldModelToForce.getClass().getName(), this.f_115290_ == null ? "null" : this.f_115290_.getClass().getName(), replace);
                if (replace) {
                    this.f_115290_ = this.emf$heldModelToForce;
                }
            }
            this.emf$heldModelToForce = null;
        }
        if (((IEMFModel)this.f_115290_).emf$isEMFModel() && (root = ((IEMFModel)this.f_115290_).emf$getEMFRootModel()) != null) {
            if (EMFConfig.getConfig().vanillaModelHologramRenderMode != EMFConfig.VanillaModelRenderMode.Off) {
                root.tryRenderVanillaRootNormally(matrixStack, vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)livingEntity))), i, OverlayTexture.f_118083_);
            }
            if (livingEntity.m_21224_() && EMFManager.getInstance().IS_PHYSICS_MOD_INSTALLED && EMFConfig.getConfig().attemptPhysicsModPatch_2 != EMFConfig.PhysicsModCompatChoice.OFF) {
                root.tryRenderVanillaFormatRoot(matrixStack, vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)livingEntity))), i, OverlayTexture.f_118083_);
            }
        }
    }

    @ModifyArg(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V"), index=1)
    private float emf$getLimbAngle(float limbAngle) {
        EMFAnimationHelper.setLimbAngle(limbAngle == Float.MIN_VALUE ? 0.0f : limbAngle);
        return limbAngle;
    }

    @ModifyArg(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V"), index=2)
    private float emf$getLimbDistance(float limbDistance) {
        EMFAnimationHelper.setLimbDistance(limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance);
        return limbDistance;
    }

    @ModifyArg(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V"), index=4)
    private float emf$getHeadYaw(float headYaw) {
        if (headYaw > 180.0f || headYaw < -180.0f) {
            float normalizedAngle = headYaw % 360.0f;
            if (normalizedAngle > 180.0f) {
                normalizedAngle -= 360.0f;
            } else if (normalizedAngle < -180.0f) {
                normalizedAngle += 360.0f;
            }
            EMFAnimationHelper.setHeadYaw(normalizedAngle);
        } else {
            EMFAnimationHelper.setHeadYaw(headYaw);
        }
        return headYaw;
    }

    @ModifyArg(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V"), index=5)
    private float emf$getHeadPitch(float headPitch) {
        EMFAnimationHelper.setHeadPitch(headPitch);
        return headPitch;
    }

    @Redirect(method={"getRenderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/LivingEntityRenderer;getTexture(Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/Identifier;"))
    private ResourceLocation emf$getTextureRedirect(LivingEntityRenderer<?, ?> instance, Entity entity) {
        EMFModelPartRoot root;
        if (((IEMFModel)this.f_115290_).emf$isEMFModel() && (root = ((IEMFModel)this.f_115290_).emf$getEMFRootModel()) != null) {
            root.removeJemOverrideTextureForModelSupplyingItAnotherWay();
            return root.textureOverride == null ? this.m_5478_((Entity)((LivingEntity)entity)) : ETFApi.getCurrentETFVariantTextureOfEntity((Entity)entity, (ResourceLocation)root.textureOverride);
        }
        return this.m_5478_((Entity)((LivingEntity)entity));
    }
}

