/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_texture_features.ETFApi;

public abstract class EMFModelPart
extends ModelPart {
    public ResourceLocation textureOverride;
    protected BufferBuilder MODIFIED_RENDER_BUFFER = null;

    public EMFModelPart(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
    }

    @Nullable
    private ResourceLocation getTextureOverrideViaETF(int renderLight) {
        if (renderLight == 0xF000F2) {
            if (EMFAnimationHelper.getEMFEntity().entity() != null) {
                return ETFApi.getCurrentETFEmissiveTextureOfEntityOrNull((Entity)EMFAnimationHelper.getEMFEntity().entity(), (ResourceLocation)this.textureOverride);
            }
            if (EMFAnimationHelper.getEMFEntity().getBlockEntity() != null) {
                return null;
            }
            return null;
        }
        if (EMFAnimationHelper.getEMFEntity().entity() != null) {
            return ETFApi.getCurrentETFVariantTextureOfEntity((Entity)EMFAnimationHelper.getEMFEntity().entity(), (ResourceLocation)this.textureOverride);
        }
        if (EMFAnimationHelper.getEMFEntity().getBlockEntity() != null) {
            return ETFApi.getCurrentETFVariantTextureOfEntity((BlockEntity)EMFAnimationHelper.getEMFEntity().getBlockEntity(), (ResourceLocation)this.textureOverride, (UUID)EMFAnimationHelper.getEMFEntity().getUuid());
        }
        return this.textureOverride;
    }

    void primaryRender(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride != null && light != 0xF000F1 && EMFAnimationHelper.getEMFEntity() != null) {
            ResourceLocation texture = this.getTextureOverrideViaETF(light);
            if (texture != null) {
                try {
                    RenderType layer = RenderType.m_110473_((ResourceLocation)texture);
                    if (this.MODIFIED_RENDER_BUFFER == null) {
                        this.MODIFIED_RENDER_BUFFER = new BufferBuilder(layer.m_110507_());
                    }
                    this.MODIFIED_RENDER_BUFFER.m_166779_(layer.m_173186_(), layer.m_110508_());
                    this.renderToSuper(matrices, (VertexConsumer)this.MODIFIED_RENDER_BUFFER, light, overlay, red, green, blue, alpha);
                    layer.m_110412_(this.MODIFIED_RENDER_BUFFER, 0, 0, 0);
                    this.MODIFIED_RENDER_BUFFER.m_85729_();
                }
                catch (Exception exception) {}
            }
        } else {
            this.renderToSuper(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    void renderToSuper(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        super.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    protected void m_104290_(PoseStack.Pose entry, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (ModelPart.Cube cuboid : ((ModelPartAccessor)((Object)this)).getCuboids()) {
            cuboid.m_171332_(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public String toString() {
        return "generic emf part";
    }

    public Map<String, ModelPart> getChildrenEMF() {
        return ((ModelPartAccessor)((Object)this)).getChildren();
    }

    abstract ModelPart getVanillaModelPartsOfCurrentState();

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        EMFModelPart eMFModelPart = this;
        if (eMFModelPart instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)eMFModelPart;
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        Map<String, ModelPart> children = this.getChildrenEMF();
        for (ModelPart part : children.values()) {
            boolean addThis;
            String thisKey;
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart part3 = (EMFModelPart)part;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partc = (EMFModelPartCustom)part;
                thisKey = partc.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partv = (EMFModelPartVanilla)part;
                thisKey = partv.name;
                addThis = partv.isOptiFinePartSpecified;
            } else {
                thisKey = "NULL_KEY_NAME";
                addThis = false;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.put((Object)thisKey, (Object)part3);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.put((Object)(prefixableParents + ":" + thisKey), (Object)part3);
                mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

