/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.EMFModelPartWithState;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartRoot
extends EMFModelPartVanilla {
    public final OptifineMobNameForFileAndEMFMapId modelName;
    public final ModelPart vanillaRoot;
    private final Map<String, EMFModelPartVanilla> allVanillaParts;
    private final Int2ObjectOpenHashMap<ModelPart> vanillaFormatModelPartOfEachState = new Int2ObjectOpenHashMap();
    public EMFManager.CemDirectoryApplier variantDirectoryApplier;
    public ETFApi.ETFRandomTexturePropertyInstance variantTester = null;
    private long lastFrameVariatedOn = -1L;
    private long lastMobCountAnimatedOn = 0L;
    private boolean removedJemTexture = false;

    public EMFModelPartRoot(OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap, EMFManager.CemDirectoryApplier variantDirectoryApplier, ModelPart vanillaRoot, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> mapForCreatedParts) {
        super("EMF_root", vanillaRoot, optifinePartNames, mapForCreatedParts);
        this.allVanillaParts = mapForCreatedParts;
        this.allVanillaParts.put(this.name, this);
        this.modelName = mobNameForFileAndMap;
        this.variantDirectoryApplier = variantDirectoryApplier;
        this.receiveStartOfRenderRunnable(emfModelPart -> {
            if (this.lastFrameVariatedOn != EMFManager.getInstance().entityRenderCount) {
                this.lastFrameVariatedOn = EMFManager.getInstance().entityRenderCount;
                EMFManager.getInstance().doVariantCheckFor(this);
            }
        });
        this.vanillaRoot = vanillaRoot;
    }

    public void addVariantOfJem(EMFJemData jemData, int variant) {
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > " + jemData.mobModelIDInfo.getfileName() + ", constructing variant #" + variant);
        }
        HashMap<String, EMFModelPartCustom> newEmfParts = new HashMap<String, EMFModelPartCustom>();
        for (EMFPartData eMFPartData : jemData.models) {
            if (eMFPartData.part == null) continue;
            String idUnique = EMFUtils.getIdUnique(newEmfParts.keySet(), eMFPartData.id);
            newEmfParts.put(idUnique, new EMFModelPartCustom(eMFPartData, variant, eMFPartData.part, idUnique));
        }
        for (Map.Entry entry : this.allVanillaParts.entrySet()) {
            EMFModelPartRoot root;
            String thisPartName = (String)entry.getKey();
            EMFModelPartVanilla thisPart = (EMFModelPartVanilla)((Object)entry.getValue());
            EMFModelPartWithState.EMFModelState vanillaState = EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)thisPart.allKnownStateVariants.get(0));
            thisPart.setFromState(vanillaState);
            if (thisPart instanceof EMFModelPartRoot && !((ModelPartAccessor)((Object)(root = (EMFModelPartRoot)thisPart))).getCuboids().isEmpty()) {
                root.textureOverride = jemData.customTexture;
            }
            HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
            for (Map.Entry newPartEntry : newEmfParts.entrySet()) {
                EMFModelPartCustom newPart = (EMFModelPartCustom)((Object)newPartEntry.getValue());
                if (!thisPartName.equals(newPart.partToBeAttached)) continue;
                if (EMFConfig.getConfig().logModelCreationData) {
                    System.out.println(" > > > EMF custom part attached: " + (String)newPartEntry.getKey());
                }
                if (!newPart.attach) {
                    ((ModelPartAccessor)((Object)thisPart)).setCuboids(List.of());
                    thisPart.getChildrenEMF().values().forEach(part -> {
                        if (part instanceof EMFModelPartVanilla) {
                            EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)((Object)part));
                            if (!vanilla.isOptiFinePartSpecified) {
                                vanilla.setHideInTheseStates(variant);
                            }
                        }
                    });
                }
                children.put(EMFUtils.getIdUnique(thisPart.getChildrenEMF().keySet(), (String)newPartEntry.getKey()), newPart);
            }
            children.putAll(thisPart.vanillaChildren);
            ((ModelPartAccessor)((Object)thisPart)).setChildren(children);
            thisPart.allKnownStateVariants.put(variant, (Object)thisPart.getCurrentState());
        }
        if (!this.allKnownStateVariants.containsKey(variant)) {
            this.allKnownStateVariants.put(variant, (Object)EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        }
    }

    @Override
    public void setVariantStateTo(int newVariantState) {
        if (this.currentModelVariantState != newVariantState) {
            if (newVariantState == 1 && !this.allKnownStateVariants.containsKey(1)) {
                super.setVariantStateTo(0);
            } else {
                EMFAnimationHelper.setRuleIndex(newVariantState);
                super.setVariantStateTo(newVariantState);
            }
        }
    }

    public void tryRenderVanillaRootNormally(PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        if (this.vanillaRoot != null) {
            matrixStack.m_85836_();
            if (EMFConfig.getConfig().vanillaModelHologramRenderMode == EMFConfig.VanillaModelRenderMode.Positon_offset) {
                matrixStack.m_85837_(1.0, 0.0, 0.0);
            }
            this.vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 0.5f, 0.5f, 0.5f);
            matrixStack.m_85849_();
        }
    }

    public void tryRenderVanillaFormatRoot(PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        if (EMFConfig.getConfig().attemptPhysicsModPatch_2 == EMFConfig.PhysicsModCompatChoice.VANILLA) {
            if (this.vanillaRoot != null) {
                this.vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            ModelPart vanillaFormat;
            if (!this.vanillaFormatModelPartOfEachState.containsKey(this.currentModelVariantState)) {
                this.vanillaFormatModelPartOfEachState.put(this.currentModelVariantState, (Object)this.getVanillaModelPartsOfCurrentState());
            }
            if ((vanillaFormat = (ModelPart)this.vanillaFormatModelPartOfEachState.get(this.currentModelVariantState)) != null) {
                vanillaFormat.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void receiveAnimations(int variant, Object2ObjectLinkedOpenHashMap<String, Object2ObjectLinkedOpenHashMap<String, EMFAnimation>> orderedAnimationsByPartName) {
        LinkedList animationList = new LinkedList();
        if (orderedAnimationsByPartName.size() > 0) {
            this.allVanillaParts.values().forEach(emf -> {
                Object2ObjectLinkedOpenHashMap anims;
                if (orderedAnimationsByPartName.containsKey((Object)emf.name) && (anims = (Object2ObjectLinkedOpenHashMap)orderedAnimationsByPartName.get((Object)emf.name)) != null && !anims.isEmpty()) {
                    anims.forEach((key, anim) -> animationList.add(anim));
                }
            });
        }
        if (animationList.size() > 0) {
            Runnable run = () -> {
                if (this.lastMobCountAnimatedOn != EMFManager.getInstance().entityRenderCount) {
                    this.lastMobCountAnimatedOn = EMFManager.getInstance().entityRenderCount;
                    animationList.forEach(EMFAnimation::calculateAndSet);
                }
            };
            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, run));
        }
    }

    public void removeJemOverrideTextureForModelSupplyingItAnotherWay() {
        if (this.removedJemTexture) {
            return;
        }
        this.removedJemTexture = true;
        if (this.textureOverride != null) {
            this.allVanillaParts.values().forEach(emf -> {
                if (emf.textureOverride.equals((Object)this.textureOverride)) {
                    emf.textureOverride = null;
                }
            });
        }
    }

    @Override
    public String toString() {
        return "[EMF_root of " + this.modelName.getfileName() + "]";
    }
}

