/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.EMFModelPartWithState;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartVanilla
extends EMFModelPartWithState {
    final String name;
    final boolean isOptiFinePartSpecified;
    final boolean rootType;
    final Set<Integer> hideInTheseStates = new HashSet<Integer>();

    public EMFModelPartVanilla(String name, ModelPart vanillaPart, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> allVanillaParts) {
        super(new ArrayList<ModelPart.Cube>(), new HashMap<String, ModelPart>());
        this.name = name;
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > EMF vanilla part made: " + name);
        }
        this.isOptiFinePartSpecified = optifinePartNames.contains(name);
        this.rootType = name.equals("root") || name.equals("EMF_root");
        EMFModelPartWithState.EMFModelState state = this.getStateOf(vanillaPart);
        this.setFromState(state);
        Map<String, ModelPart> children = this.getChildrenEMF();
        for (Map.Entry<String, ModelPart> child : ((ModelPartAccessor)vanillaPart).getChildren().entrySet()) {
            EMFModelPartVanilla vanilla = new EMFModelPartVanilla(child.getKey(), child.getValue(), optifinePartNames, allVanillaParts);
            children.put(child.getKey(), vanilla);
            allVanillaParts.put(child.getKey(), vanilla);
        }
        this.vanillaChildren = this.getChildrenEMF();
        this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
    }

    @Override
    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.hideInTheseStates.contains(this.currentModelVariantState)) {
            super.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    ModelPart getVanillaModelPartsOfCurrentState() {
        HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
        for (Map.Entry<String, ModelPart> child : this.getChildrenEMF().entrySet()) {
            ModelPart modelPart = child.getValue();
            if (!(modelPart instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)modelPart;
            children.put(child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        ModelPart part = new ModelPart(((ModelPartAccessor)((Object)this)).getCuboids(), children);
        part.m_233560_(this.m_233566_());
        part.f_104203_ = this.f_104203_;
        part.f_104205_ = this.f_104205_;
        part.f_104204_ = this.f_104204_;
        part.f_104202_ = this.f_104202_;
        part.f_104201_ = this.f_104201_;
        part.f_104200_ = this.f_104200_;
        part.f_233553_ = this.f_233553_;
        part.f_233554_ = this.f_233554_;
        part.f_233555_ = this.f_233555_;
        return part;
    }

    public void setHideInTheseStates(int variant) {
        this.hideInTheseStates.add(variant);
        this.getChildrenEMF().values().forEach(part -> {
            if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                if (!vanilla.isOptiFinePartSpecified) {
                    vanilla.setHideInTheseStates(variant);
                }
            }
        });
    }

    public void receiveRootAnimationRunnable(int variant, Runnable run) {
        ((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(variant)).animation().setAnimation(run);
    }

    @Override
    public String toString() {
        return "[vanilla part " + this.name + "]";
    }
}

