/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;

public abstract class EMFModelPartWithState
extends EMFModelPart {
    public final Int2ObjectOpenHashMap<EMFModelState> allKnownStateVariants = new Int2ObjectOpenHashMap();
    public int currentModelVariantState = 0;
    Map<String, ModelPart> vanillaChildren = new HashMap<String, ModelPart>();
    Consumer<EMFModelPartWithState> startOfRenderRunnable = null;
    EMFModelPart.Animator tryAnimate = new EMFModelPart.Animator();

    public EMFModelPartWithState(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
    }

    void receiveStartOfRenderRunnable(Consumer<EMFModelPartWithState> run) {
        this.startOfRenderRunnable = run;
        this.getChildrenEMF().values().forEach(child -> {
            if (child instanceof EMFModelPartWithState) {
                EMFModelPartWithState emf = (EMFModelPartWithState)((Object)child);
                emf.receiveStartOfRenderRunnable(run);
            }
        });
    }

    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.startOfRenderRunnable != null) {
            this.startOfRenderRunnable.accept(this);
        }
        if (this.tryAnimate != null) {
            this.tryAnimate.run();
        }
        this.primaryRender(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    EMFModelState getCurrentState() {
        return new EMFModelState(this.m_233566_(), ((ModelPartAccessor)((Object)this)).getCuboids(), this.getChildrenEMF(), this.f_233553_, this.f_233554_, this.f_233555_, this.f_104207_, this.f_233556_, this.textureOverride, this.tryAnimate);
    }

    EMFModelState getStateOf(ModelPart modelPart) {
        if (modelPart instanceof EMFModelPartWithState) {
            EMFModelPartWithState emf = (EMFModelPartWithState)modelPart;
            return new EMFModelState(modelPart.m_233566_(), ((ModelPartAccessor)modelPart).getCuboids(), emf.getChildrenEMF(), modelPart.f_233553_, modelPart.f_233554_, modelPart.f_233555_, modelPart.f_104207_, modelPart.f_233556_, emf.textureOverride, emf.tryAnimate);
        }
        return new EMFModelState(modelPart.m_233566_(), ((ModelPartAccessor)modelPart).getCuboids(), new HashMap<String, ModelPart>(), modelPart.f_233553_, modelPart.f_233554_, modelPart.f_233555_, modelPart.f_104207_, modelPart.f_233556_, null, new EMFModelPart.Animator());
    }

    void setFromState(EMFModelState newState) {
        this.m_233560_(newState.defaultTransform());
        this.m_171322_(this.m_233566_());
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        ((ModelPartAccessor)((Object)this)).setChildren(newState.variantChildren());
        this.f_233553_ = newState.xScale();
        this.f_233554_ = newState.yScale();
        this.f_233555_ = newState.zScale();
        this.f_104207_ = newState.visible();
        this.f_233556_ = newState.hidden();
        this.textureOverride = newState.texture();
        this.tryAnimate = newState.animation();
    }

    void setFromStateVariant(EMFModelState newState, @Nullable EMFModelState oldState) {
        PartPose oldDefault = this.m_233566_();
        this.m_233560_(newState.defaultTransform());
        this.setTransformOnlyChangingDefaults(this.m_233566_(), oldDefault);
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        ((ModelPartAccessor)((Object)this)).setChildren(newState.variantChildren());
        if (oldState == null || this.f_233553_ == oldState.xScale()) {
            this.f_233553_ = newState.xScale();
        }
        if (oldState == null || this.f_233554_ == oldState.yScale()) {
            this.f_233554_ = newState.yScale();
        }
        if (oldState == null || this.f_233555_ == oldState.zScale()) {
            this.f_233555_ = newState.zScale();
        }
        if (oldState == null || this.f_104207_ == oldState.visible()) {
            this.f_104207_ = newState.visible();
        }
        if (oldState == null || this.f_233556_ == oldState.hidden()) {
            this.f_233556_ = newState.hidden();
        }
        this.textureOverride = newState.texture();
        this.tryAnimate = newState.animation();
    }

    public void setTransformOnlyChangingDefaults(PartPose newDefault, PartPose oldDefault) {
        if (this.f_104200_ == oldDefault.f_171405_) {
            this.f_104200_ = newDefault.f_171405_;
        }
        if (this.f_104201_ == oldDefault.f_171406_) {
            this.f_104201_ = newDefault.f_171406_;
        }
        if (this.f_104202_ == oldDefault.f_171405_) {
            this.f_104202_ = newDefault.f_171407_;
        }
        if (this.f_104203_ == oldDefault.f_171408_) {
            this.f_104203_ = newDefault.f_171408_;
        }
        if (this.f_104204_ == oldDefault.f_171409_) {
            this.f_104204_ = newDefault.f_171409_;
        }
        if (this.f_104205_ == oldDefault.f_171410_) {
            this.f_104205_ = newDefault.f_171410_;
        }
    }

    public void setVariantStateTo(int newVariantState) {
        if (this.currentModelVariantState != newVariantState) {
            this.currentModelVariantState = newVariantState;
            if (this.allKnownStateVariants.containsKey(newVariantState)) {
                this.setFromStateVariant((EMFModelState)this.allKnownStateVariants.get(newVariantState), (EMFModelState)this.allKnownStateVariants.get(this.currentModelVariantState));
            }
            for (ModelPart part : this.getChildrenEMF().values()) {
                if (!(part instanceof EMFModelPartWithState)) continue;
                EMFModelPartWithState p3 = (EMFModelPartWithState)part;
                p3.setVariantStateTo(newVariantState);
            }
        }
    }

    record EMFModelState(PartPose defaultTransform, List<ModelPart.Cube> cuboids, Map<String, ModelPart> variantChildren, float xScale, float yScale, float zScale, boolean visible, boolean hidden, ResourceLocation texture, EMFModelPart.Animator animation) {
        public static EMFModelState copy(EMFModelState copyFrom) {
            PartPose trans = copyFrom.defaultTransform();
            EMFModelPart.Animator animator = new EMFModelPart.Animator();
            animator.setAnimation(copyFrom.animation().getAnimation());
            return new EMFModelState(PartPose.m_171423_((float)trans.f_171405_, (float)trans.f_171406_, (float)trans.f_171407_, (float)trans.f_171408_, (float)trans.f_171409_, (float)trans.f_171410_), new ArrayList<ModelPart.Cube>(copyFrom.cuboids()), new HashMap<String, ModelPart>(copyFrom.variantChildren()), copyFrom.xScale(), copyFrom.yScale(), copyFrom.zScale(), copyFrom.visible(), copyFrom.hidden(), copyFrom.texture(), animator);
        }
    }
}

