/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import traben.entity_model_features.mixin.accessor.EntityRenderDispatcherAccessor;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.utils.EMFBlockEntityWrapper;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFEntityWrapper;
import traben.entity_model_features.utils.EMFManager;

public class EMFAnimationHelper {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private static EMFEntity emfEntity = null;
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static float tickDelta = 0.0f;
    private static int ruleIndex = 0;
    private static float dimension = Float.NaN;
    private static boolean onShoulder = false;

    private EMFAnimationHelper() {
    }

    public static void setCurrentEntity(Entity entityIn) {
        EMFAnimationHelper.resetForNewEntity();
        ++EMFManager.getInstance().entityRenderCount;
        emfEntity = entityIn == null ? null : new EMFEntityWrapper(entityIn);
    }

    public static void setCurrentBlockEntity(BlockEntity entityIn) {
        EMFAnimationHelper.resetForNewEntity();
        ++EMFManager.getInstance().entityRenderCount;
        emfEntity = entityIn == null ? null : new EMFBlockEntityWrapper(entityIn);
    }

    public static void resetForNewEntity() {
        dimension = Float.NaN;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        tickDelta = Minecraft.m_91087_().m_91104_() ? ((MinecraftClientAccessor)Minecraft.m_91087_()).getPausedTickDelta() : Minecraft.m_91087_().m_91296_();
        ruleIndex = 0;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        onShoulder = false;
    }

    public static float getRuleIndex() {
        return ruleIndex;
    }

    public static void setRuleIndex(int newIndex) {
        ruleIndex = newIndex;
    }

    public static EMFEntity getEMFEntity() {
        return emfEntity;
    }

    public static float getDimension() {
        if (Float.isNaN(dimension)) {
            ResourceLocation id;
            dimension = emfEntity == null || emfEntity.getWorld() == null ? 0.0f : ((id = emfEntity.getWorld().m_220362_().m_135782_()).equals((Object)BuiltinDimensionTypes.f_223543_) ? -1.0f : (id.equals((Object)BuiltinDimensionTypes.f_223544_) ? 1.0f : 0.0f));
        }
        return dimension;
    }

    public static float getPlayerX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19854_, (double)Minecraft.m_91087_().f_91074_.m_20185_());
    }

    public static float getPlayerY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19855_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
    }

    public static float getPlayerZ() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19856_, (double)Minecraft.m_91087_().f_91074_.m_20189_());
    }

    public static float getPlayerRX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19860_, (float)Minecraft.m_91087_().f_91074_.m_146909_()));
    }

    public static float getPlayerRY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19859_, (float)Minecraft.m_91087_().f_91074_.m_146908_()));
    }

    public static float getEntityX() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevX(), (double)emfEntity.getX());
    }

    public static float getEntityY() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevY(), (double)emfEntity.getY());
    }

    public static float getEntityZ() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevZ(), (double)emfEntity.getZ());
    }

    public static float getEntityRX() {
        return emfEntity == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)emfEntity.prevPitch(), (float)emfEntity.getPitch()));
    }

    public static float getEntityRY() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)alive.f_20884_, (float)alive.m_213816_())) : (emfEntity.entity() != null ? (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)EMFAnimationHelper.emfEntity.entity().f_19859_, (float)emfEntity.entity().m_146908_())) : 0.0f);
    }

    public static float getTime() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        long upTimeInTicks = emfEntity.getWorld().m_46467_();
        return EMFAnimationHelper.constrainedFloat(upTimeInTicks, 720720) + tickDelta;
    }

    public static float getDayTime() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationHelper.constrainedFloat(emfEntity.getWorld().m_46468_(), 24000) + tickDelta;
    }

    public static float getDayCount() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return (float)(emfEntity.getWorld().m_46468_() / 24000L) + tickDelta;
    }

    public static float getHealth() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? alive.m_21223_() : 1.0f;
    }

    public static float getDeathTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? (float)alive.f_20919_ : 0.0f;
    }

    public static float getAngerTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        if (!(alive instanceof NeutralMob)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfEntity.getUuid());
        int angerTime = ((NeutralMob)alive).m_6784_();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.getUuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.getUuid(), angerTime);
        }
        return (float)angerTime - tickDelta;
    }

    public static float getAngerTimeStart() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return !(alive instanceof NeutralMob) ? 0.0f : (float)knownHighestAngerTimeByUUID.getInt((Object)alive.m_20148_());
    }

    public static float getMaxHealth() {
        if (emfEntity == null) {
            return 1.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? alive.m_21233_() : 1.0f;
    }

    public static float getId() {
        return emfEntity == null ? 0.0f : (float)emfEntity.getUuid().hashCode();
    }

    public static float getHurtTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? (alive.f_20916_ > 0 ? (float)alive.f_20916_ - tickDelta : 0.0f) : 0.0f;
    }

    public static boolean isInWater() {
        return emfEntity != null && emfEntity.isTouchingWater();
    }

    public static boolean isBurning() {
        return emfEntity != null && emfEntity.isOnFire();
    }

    public static boolean isRiding() {
        return emfEntity != null && emfEntity.hasVehicle();
    }

    public static boolean isChild() {
        if (emfEntity == null) {
            return false;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null && alive.m_6162_();
    }

    public static boolean isOnGround() {
        return emfEntity != null && emfEntity.isOnGround();
    }

    public static boolean isClimbing() {
        if (emfEntity == null) {
            return false;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null && alive.m_6147_();
    }

    public static boolean isAlive() {
        if (emfEntity == null) {
            return false;
        }
        return emfEntity.isAlive();
    }

    public static boolean isAggressive() {
        if (emfEntity == null) {
            return false;
        }
        Entity entity = emfEntity.entity();
        return entity instanceof Mob && ((Mob)entity).m_5912_();
    }

    public static boolean isGlowing() {
        return emfEntity != null && emfEntity.isGlowing();
    }

    public static boolean isHurt() {
        if (emfEntity == null) {
            return false;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null && alive.f_20916_ > 0;
    }

    public static boolean isInHand() {
        return false;
    }

    public static boolean isInItemFrame() {
        return false;
    }

    public static boolean isInGround() {
        Projectile proj;
        if (emfEntity == null) {
            return false;
        }
        Entity entity = emfEntity.entity();
        return entity instanceof Projectile && (proj = (Projectile)entity).m_5830_();
    }

    public static boolean isInGui() {
        return Minecraft.m_91087_().f_91080_ != null && !((EntityRenderDispatcherAccessor)Minecraft.m_91087_().m_91290_()).isRenderShadows();
    }

    public static boolean isInLava() {
        return emfEntity != null && emfEntity.isInLava();
    }

    public static boolean isInvisible() {
        return emfEntity != null && emfEntity.isInvisible();
    }

    public static boolean isOnHead() {
        return false;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder() {
        onShoulder = true;
    }

    public static boolean isRidden() {
        return emfEntity != null && emfEntity.hasPassengers();
    }

    public static boolean isSitting() {
        Wolf wolf;
        Cat cat;
        Parrot parrot;
        Fox fox;
        TamableAnimal tame;
        if (emfEntity == null) {
            return false;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null && (alive instanceof TamableAnimal && (tame = (TamableAnimal)alive).m_21825_() || alive instanceof Fox && (fox = (Fox)alive).m_28555_() || alive instanceof Parrot && (parrot = (Parrot)alive).m_21825_() || alive instanceof Cat && (cat = (Cat)alive).m_21825_() || alive instanceof Wolf && (wolf = (Wolf)alive).m_21825_());
    }

    public static boolean isSneaking() {
        return emfEntity != null && emfEntity.isSneaking();
    }

    public static boolean isSprinting() {
        return emfEntity != null && emfEntity.isSprinting();
    }

    public static boolean isTamed() {
        TamableAnimal tame;
        if (emfEntity == null) {
            return false;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive instanceof TamableAnimal && (tame = (TamableAnimal)alive).m_21824_();
    }

    public static boolean isWet() {
        return emfEntity != null && emfEntity.isWet();
    }

    public static float getSwingProgress() {
        if (emfEntity == null) {
            return 0.0f;
        }
        LivingEntity alive = emfEntity.getLiving();
        return alive != null ? alive.m_21324_(tickDelta) : 0.0f;
    }

    public static float getAge() {
        if (emfEntity == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationHelper.constrainedFloat(emfEntity.age(), 24000) + tickDelta;
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    public static float getFrameTime() {
        return Minecraft.m_91087_().m_91297_() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationHelper.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationHelper.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationHelper.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationHelper.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        float o = 0.0f;
        float n = 0.0f;
        LivingEntity alive = emfEntity.getLiving();
        if (alive != null && !alive.m_20159_()) {
            n = Mth.m_14179_((float)tickDelta, (float)alive.f_20923_, (float)alive.f_20924_);
            o = alive.f_20925_ - alive.f_20924_ * (1.0f - tickDelta);
            if (alive.m_6162_()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (emfEntity.entity() instanceof Minecart) {
            n = 1.0f;
            o = -(EMFAnimationHelper.getEntityX() + EMFAnimationHelper.getEntityZ());
        } else {
            Entity entity = emfEntity.entity();
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                n = 1.0f;
                o = Math.max(boat.m_38315_(1, tickDelta), boat.m_38315_(0, tickDelta));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationHelper.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationHelper.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationHelper.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationHelper.headPitch = headPitch;
    }

    private static void doHeadValues() {
        LivingEntity livingEntity = emfEntity.getLiving();
        if (livingEntity != null) {
            Entity entity;
            float h = Mth.m_14189_((float)tickDelta, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
            float j = Mth.m_14189_((float)tickDelta, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
            float k = j - h;
            if (livingEntity.m_20159_() && (entity = livingEntity.m_20202_()) instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                h = Mth.m_14189_((float)tickDelta, (float)livingEntity2.f_20884_, (float)livingEntity2.f_20883_);
                k = j - h;
                float l = Mth.m_14177_((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = Mth.m_14179_((float)tickDelta, (float)livingEntity.f_19860_, (float)livingEntity.m_146909_());
            if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            if (k > 180.0f || k < -180.0f) {
                float normalizedAngle = k % 360.0f;
                if (normalizedAngle > 180.0f) {
                    normalizedAngle -= 360.0f;
                } else if (normalizedAngle < -180.0f) {
                    normalizedAngle += 360.0f;
                }
                headYaw = normalizedAngle;
            } else {
                headYaw = k;
            }
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return tickDelta;
    }

    public static float getMoveForward() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.getYaw());
        Vec3 velocity = emfEntity.getVelocity();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationHelper.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.getYaw());
        Vec3 velocity = emfEntity.getVelocity();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationHelper.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationHelper.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationHelper.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationHelper.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationHelper.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationHelper.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationHelper.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationHelper.shadowZ = shadowZ;
    }
}

