/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.Mth;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathExpressionParser;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;

public class MathMethod
extends MathValue
implements MathComponent {
    final String methodName;
    public MathComponent optimizedAlternativeToThis = null;
    MathValue.ValueSupplier supplier;
    private int printCount = 0;

    private MathMethod(String methodName, String args, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        super(isNegative, calculationInstance);
        this.methodName = methodName;
        ArrayList<String> argsList = new ArrayList<String>();
        int openBracketCount = 0;
        StringBuilder builder = new StringBuilder();
        block71: for (char ch : args.toCharArray()) {
            switch (ch) {
                case '(': {
                    ++openBracketCount;
                    builder.append(ch);
                    continue block71;
                }
                case ')': {
                    --openBracketCount;
                    builder.append(ch);
                    continue block71;
                }
                case ',': {
                    if (openBracketCount == 0) {
                        argsList.add(builder.toString());
                        builder = new StringBuilder();
                        continue block71;
                    }
                    builder.append(ch);
                    continue block71;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        argsList.add(builder.toString());
        this.supplier = switch (methodName) {
            case "if" -> this.EMF_IF(argsList);
            case "sin" -> this.SIN(argsList);
            case "asin" -> this.ASIN(argsList);
            case "cos" -> this.COS(argsList);
            case "acos" -> this.ACOS(argsList);
            case "tan" -> this.TAN(argsList);
            case "atan" -> this.ATAN(argsList);
            case "atan2" -> this.ATAN2(argsList);
            case "torad" -> this.TORAD(argsList);
            case "todeg" -> this.TODEG(argsList);
            case "min" -> this.MIN(argsList);
            case "max" -> this.MAX(argsList);
            case "clamp" -> this.CLAMP(argsList);
            case "abs" -> this.ABS(argsList);
            case "floor" -> this.FLOOR(argsList);
            case "ceil" -> this.CEIL(argsList);
            case "exp" -> this.EXP(argsList);
            case "frac" -> this.FRAC(argsList);
            case "log" -> this.LOG(argsList);
            case "pow" -> this.POW(argsList);
            case "random" -> this.RANDOM(argsList);
            case "round" -> this.ROUND(argsList);
            case "signum" -> this.SIGNUM(argsList);
            case "sqrt" -> this.SQRT(argsList);
            case "fmod" -> this.FMOD(argsList);
            case "lerp" -> this.LERP(argsList);
            case "print" -> this.PRINT(argsList);
            case "printb" -> this.PRINTB(argsList);
            case "between" -> this.BETWEEN(argsList);
            case "equals" -> this.EQUALS(argsList);
            case "in" -> this.IN(argsList);
            default -> throw new MathComponent.EMFMathException("ERROR: Unknown method [" + methodName + "], rejecting animation expression for [" + calculationInstance.animKey + "].");
        };
    }

    public static MathComponent getOptimizedExpression(String methodName, String args, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        MathMethod method = new MathMethod(methodName, args, isNegative, calculationInstance);
        return Objects.requireNonNullElse(method.optimizedAlternativeToThis, method);
    }

    private void setOptimizedIfPossible(List<MathComponent> allComponents, MathValue.ValueSupplier supplier) {
        float constantResult;
        boolean foundNonConstant = false;
        for (MathComponent comp : allComponents) {
            if (comp.isConstant()) continue;
            foundNonConstant = true;
            break;
        }
        if (!foundNonConstant && !Float.isNaN(constantResult = supplier.get())) {
            this.optimizedAlternativeToThis = new MathConstant(constantResult, this.isNegative);
        }
    }

    private MathValue.ValueSupplier IN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() >= 3) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            ArrayList<MathComponent> vals = new ArrayList<MathComponent>();
            for (int i = 1; i < args.size(); ++i) {
                vals.add(MathExpressionParser.getOptimizedExpression(args.get(i), false, this.calculationInstance));
            }
            MathValue.ValueSupplier valueSupplier = () -> {
                float X = x.get();
                for (MathComponent expression : vals) {
                    if (expression.get() != X) continue;
                    return 1.0f;
                }
                return 0.0f;
            };
            ArrayList<MathComponent> comps = new ArrayList<MathComponent>(vals);
            comps.add(x);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in IN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier EQUALS(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent y = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent epsilon = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float X = x.get();
                float Y = y.get();
                float BIGGER = Math.max(X, Y);
                float SMALLER = Math.min(X, Y);
                float EPSILON = epsilon.get();
                return Math.abs(BIGGER - SMALLER) <= EPSILON ? 1.0f : 0.0f;
            };
            List<MathComponent> comps = List.of(x, y, epsilon);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in EQUALS method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier BETWEEN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent min = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent max = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float MAX;
                float X = x.get();
                return X > (MAX = max.get()) ? 0.0f : (X < min.get() ? 0.0f : 1.0f);
            };
            List<MathComponent> comps = List.of(x, min, max);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in BETWEEN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private int getPrintCount() {
        ++this.printCount;
        return this.printCount;
    }

    private MathValue.ValueSupplier PRINTB(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            String id = args.get(0);
            MathComponent n = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float xVal = x.get();
                if ((float)this.getPrintCount() % n.get() == 0.0f) {
                    System.out.println("EMF printb: [" + id + "] = " + (xVal == 1.0f));
                }
                return xVal;
            };
            List<MathComponent> comps = List.of(n, x);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in PRINTB method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier PRINT(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            String id = args.get(0);
            MathComponent n = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float xVal = x.get();
                if ((float)this.getPrintCount() % n.get() == 0.0f) {
                    System.out.println("EMF print: [" + id + "] = " + xVal);
                }
                return xVal;
            };
            List<MathComponent> comps = List.of(n, x);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in PRINT method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier LERP(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            MathComponent k = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent y = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> Mth.m_14179_((float)k.get(), (float)x.get(), (float)y.get());
            List<MathComponent> comps = List.of(k, x, y);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in LERP method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier FMOD(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 2) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent y = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> Math.floorMod((int)x.get(), (int)y.get());
            List<MathComponent> comps = List.of(x, y);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in FMOD method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier SQRT(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.sqrt(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in SQRT method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier SIGNUM(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> Math.signum(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in SIGNUM method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ROUND(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> Math.round(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ROUND method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier RANDOM(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 0) {
            return () -> (float)Math.random();
        }
        if (args.size() == 1) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> new Random((long)x.get()).nextFloat(1.0f);
            List<MathComponent> comps = List.of(x);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in RANDOM method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier POW(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 2) {
            MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent y = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.pow(x.get(), y.get());
            List<MathComponent> comps = List.of(x, y);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in POW method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier LOG(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.log(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in LOG method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier FRAC(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float x = arg.get();
                return (float)((double)x - Math.floor(x));
            };
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in FRAC method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier EXP(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.exp(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in EXP method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier CEIL(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.ceil(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in CEIL method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier FLOOR(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.floor(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in FLOOR method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ABS(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> Math.abs(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ABS method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier CLAMP(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent arg1 = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent arg2 = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> {
                float x = arg.get();
                float min = arg1.get();
                float max = arg2.get();
                return x > max ? max : Math.max(x, min);
            };
            List<MathComponent> comps = List.of(arg1, arg2, arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in CLAMP method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier MAX(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() >= 2) {
            ArrayList<MathComponent> exps = new ArrayList<MathComponent>();
            for (String arg : args) {
                exps.add(MathExpressionParser.getOptimizedExpression(arg, false, this.calculationInstance));
            }
            MathValue.ValueSupplier valueSupplier = () -> {
                float largest = -3.4028235E38f;
                for (MathComponent expression : exps) {
                    float get = expression.get();
                    if (!(get > largest)) continue;
                    largest = get;
                }
                return largest;
            };
            this.setOptimizedIfPossible(exps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in MAX method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier MIN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() >= 2) {
            ArrayList<MathComponent> exps = new ArrayList<MathComponent>();
            for (String arg : args) {
                exps.add(MathExpressionParser.getOptimizedExpression(arg, false, this.calculationInstance));
            }
            MathValue.ValueSupplier valueSupplier = () -> {
                float smallest = Float.MAX_VALUE;
                for (MathComponent expression : exps) {
                    float get = expression.get();
                    if (!(get < smallest)) continue;
                    smallest = get;
                }
                return smallest;
            };
            this.setOptimizedIfPossible(exps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in MIN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier TORAD(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.toRadians(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in TORAD method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier TODEG(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.toDegrees(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in TODEG method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier SIN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.sin(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in SIN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ASIN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.asin(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ASIN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier COS(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.cos(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in COS method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ACOS(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.acos(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ACOS method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier TAN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.tan(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in TAN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ATAN(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 1) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.atan(arg.get());
            List<MathComponent> comps = List.of(arg);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ATAN method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier ATAN2(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 2) {
            MathComponent arg = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent arg2 = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathValue.ValueSupplier valueSupplier = () -> (float)Math.atan2(arg.get(), arg2.get());
            List<MathComponent> comps = List.of(arg, arg2);
            this.setOptimizedIfPossible(comps, valueSupplier);
            return valueSupplier;
        }
        String s = "ERROR: wrong number of arguments " + args + " in ATAN2 method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier EMF_IF(List<String> args) throws MathComponent.EMFMathException {
        if (args.size() == 3) {
            MathComponent bool = MathExpressionParser.getOptimizedExpression(args.get(0), false, this.calculationInstance);
            MathComponent tru = MathExpressionParser.getOptimizedExpression(args.get(1), false, this.calculationInstance);
            MathComponent fals = MathExpressionParser.getOptimizedExpression(args.get(2), false, this.calculationInstance);
            if (bool.isConstant()) {
                this.optimizedAlternativeToThis = bool.get() == 1.0f ? tru : fals;
            }
            return () -> bool.get() == 1.0f ? tru.get() : fals.get();
        }
        if (args.size() % 2 == 1) {
            ArrayList<MathComponent> expList = new ArrayList<MathComponent>();
            for (String str : args) {
                expList.add(MathExpressionParser.getOptimizedExpression(str, false, this.calculationInstance));
            }
            return () -> {
                boolean lastCondition = false;
                for (int i = 0; i < expList.size(); ++i) {
                    if (i == expList.size() - 1) {
                        return ((MathComponent)expList.get(i)).get();
                    }
                    if (i % 2 == 0) {
                        lastCondition = ((MathComponent)expList.get(i)).get() == 1.0f;
                        continue;
                    }
                    if (!lastCondition) continue;
                    return ((MathComponent)expList.get(i)).get();
                }
                String s = "ERROR: in IF method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
                System.out.println(s);
                return Float.NaN;
            };
        }
        String s = "ERROR: wrong number of arguments " + args + " in IF method for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    public String toString() {
        return this.methodName + "()";
    }

    @Override
    public MathValue.ValueSupplier getSupplier() {
        return this.supplier;
    }
}

