/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.animation.EMFModelOrRenderVariable;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;

public class EMFManager {
    public static WolfModel<Wolf> wolfCollarModel = null;
    public static EMFModelPartRoot lastCreatedRootModelPart = null;
    private static EMFManager self = null;
    public final boolean IS_PHYSICS_MOD_INSTALLED;
    public final boolean IS_IRIS_INSTALLED;
    private final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    private final Object2BooleanOpenHashMap<UUID> cache_UUIDDoUpdating = new Object2BooleanOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(true);
        }
    };
    private final Object2IntOpenHashMap<UUIDAndMobTypeKey> cache_UUIDAndTypeToCurrentVariantInt = new Object2IntOpenHashMap<UUIDAndMobTypeKey>(){
        {
            this.defaultReturnValue(1);
        }
    };
    public long entityRenderCount = 0L;
    public boolean isAnimationValidationPhase = false;
    public String currentSpecifiedModelLoading = "";
    private boolean traderLlamaHappened = false;

    private EMFManager() {
        EMFAnimationHelper.resetForNewEntity();
        this.IS_PHYSICS_MOD_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("physicsmod");
        this.IS_IRIS_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("iris") || EMFVersionDifferenceManager.isThisModLoaded("oculus");
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.EMFModMessage("Clearing EMF data.");
        EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    public static ModelPart traverseRootForChildOrNull(ModelPart root, String nameOfModelToFind) {
        if (root.m_233562_(nameOfModelToFind)) {
            return root.m_171324_(nameOfModelToFind);
        }
        for (ModelPart part : ((ModelPartAccessor)root).getChildren().values()) {
            ModelPart found = EMFManager.traverseRootForChildOrNull(part, nameOfModelToFind);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static String getTypeName(Entity entity) {
        Object forReturn = Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString().replace("minecraft:", "");
        if (((String)forReturn).contains(":")) {
            forReturn = "modded/" + ((String)forReturn).replaceFirst(":", "/");
        }
        if (entity instanceof Pufferfish) {
            Pufferfish puffer = (Pufferfish)entity;
            forReturn = "puffer_fish_" + (switch (puffer.m_29631_()) {
                case 0 -> "small";
                case 1 -> "medium";
                default -> "big";
            });
        } else if (entity instanceof TropicalFish) {
            TropicalFish fish = (TropicalFish)entity;
            forReturn = fish.m_30045_() == 0 ? "tropical_fish_a" : "tropical_fish_b";
        } else if (entity instanceof EnderDragon) {
            forReturn = "dragon";
        }
        return forReturn;
    }

    @Nullable
    public static EMFJemData getJemData(String jemFileName, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        EMFJemData emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        return emfJemData;
    }

    @Nullable
    public static CemDirectoryApplier getResourceCemDirectoryApplierOrNull(String inCemPathResource, String rawMobName) {
        ResourceManager resources = Minecraft.m_91087_().m_91098_();
        if (resources.m_213713_(new ResourceLocation("emf/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF();
        }
        if (resources.m_213713_(new ResourceLocation("emf/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF_Mob(rawMobName);
        }
        if (resources.m_213713_(new ResourceLocation("optifine/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCEM();
        }
        if (resources.m_213713_(new ResourceLocation("optifine/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCem_Mob(rawMobName);
        }
        return null;
    }

    @Nullable
    private static EMFJemData getJemDataWithDirectory(String pathOfJem, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        try {
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(pathOfJem));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.EMFModMessage(".jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.EMFModMessage(".jem read success " + pathOfJem + " exists", false);
            }
            Resource jemResource = (Resource)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.m_215507_()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.prepare(pathOfJem, mobModelIDInfo);
            if (mobModelIDInfo.areBothSame()) {
                EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            }
            return jem;
        }
        catch (FileNotFoundException | ResourceLocationException e) {
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.EMFModMessage(".jem failed to load " + (Exception)e, false);
            }
        }
        catch (Exception e) {
            EMFUtils.EMFModMessage(".jem failed to load " + e, false);
            e.printStackTrace();
        }
        return null;
    }

    public static EMFModelPart getModelFromHierarchichalId(String hierarchId, Map<String, EMFModelPart> map) {
        if (hierarchId == null || hierarchId.isBlank()) {
            return null;
        }
        if (!hierarchId.contains(":")) {
            EMFModelPart part = map.get(hierarchId);
            if (part == null) {
                return map.get("EMF_" + hierarchId);
            }
            return part;
        }
        for (Map.Entry<String, EMFModelPart> entry : map.entrySet()) {
            if (entry.getKey().equals(hierarchId) || entry.getKey().equals("EMF_" + hierarchId) || entry.getKey().endsWith(":" + hierarchId) || entry.getKey().endsWith(":EMF_" + hierarchId)) {
                return entry.getValue();
            }
            boolean anyMissing = false;
            String last = "";
            String[] stringArray = hierarchId.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String str;
                last = str = stringArray[i];
                if (entry.getKey().contains(str) || entry.getKey().contains("EMF_" + str)) continue;
                anyMissing = true;
                break;
            }
            if (anyMissing || !entry.getKey().endsWith(last)) continue;
            return entry.getValue();
        }
        System.out.println("NULL animation hierachy id result of: " + hierarchId + "\n in " + map);
        return null;
    }

    public ModelPart injectIntoModelRootGetter(ModelLayerLocation layer, ModelPart root) {
        lastCreatedRootModelPart = null;
        boolean printing = EMFConfig.getConfig().logModelCreationData;
        OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap = new OptifineMobNameForFileAndEMFMapId(layer.m_171123_().m_135815_());
        if (!"main".equals(layer.m_171124_())) {
            mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName() + "_" + layer.m_171124_());
        }
        if (!"minecraft".equals(layer.m_171123_().m_135827_())) {
            mobNameForFileAndMap.setBoth(("modded/" + layer.m_171123_().m_135827_() + "/" + mobNameForFileAndMap).toLowerCase().replaceAll("[^a-z0-9/._-]", "_"));
        } else {
            if (mobNameForFileAndMap.getfileName().contains("pufferfish")) {
                mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName().replace("pufferfish", "puffer_fish"));
            }
            switch (mobNameForFileAndMap.getfileName()) {
                case "tropical_fish_large": {
                    mobNameForFileAndMap.setBoth("tropical_fish_b");
                    break;
                }
                case "tropical_fish_small": {
                    mobNameForFileAndMap.setBoth("tropical_fish_a");
                    break;
                }
                case "tropical_fish_large_pattern": {
                    mobNameForFileAndMap.setBoth("tropical_fish_pattern_b");
                    break;
                }
                case "tropical_fish_small_pattern": {
                    mobNameForFileAndMap.setBoth("tropical_fish_pattern_a");
                    break;
                }
                case "leash_knot": {
                    mobNameForFileAndMap.setBoth("lead_knot");
                    break;
                }
                case "trader_llama": {
                    this.traderLlamaHappened = true;
                    break;
                }
                case "llama": {
                    this.traderLlamaHappened = false;
                    break;
                }
                case "llama_decor": {
                    mobNameForFileAndMap.setBoth(this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor");
                    break;
                }
                case "ender_dragon": {
                    mobNameForFileAndMap.setBoth("dragon");
                    break;
                }
                case "dragon_skull": {
                    mobNameForFileAndMap.setBoth("head_dragon");
                    break;
                }
                case "player_head": {
                    mobNameForFileAndMap.setBoth("head_player");
                    break;
                }
                case "skeleton_skull": {
                    mobNameForFileAndMap.setBoth("head_skeleton");
                    break;
                }
                case "wither_skeleton_skull": {
                    mobNameForFileAndMap.setBoth("head_wither_skeleton");
                    break;
                }
                case "zombie_head": {
                    mobNameForFileAndMap.setBoth("head_zombie");
                    break;
                }
                case "creeper_head": {
                    mobNameForFileAndMap.setBoth("head_creeper");
                    break;
                }
                case "piglin_head": {
                    mobNameForFileAndMap.setBoth("head_piglin");
                    break;
                }
                case "creeper_armor": {
                    mobNameForFileAndMap.setBoth("creeper_charge");
                    break;
                }
                case "sheep_fur": {
                    mobNameForFileAndMap.setBoth("sheep_wool");
                    break;
                }
                case "bed_head": {
                    mobNameForFileAndMap.setBoth("bed", "bed_head");
                    break;
                }
                case "bed_foot": {
                    mobNameForFileAndMap.setBoth("bed", "bed_foot");
                    break;
                }
                case "conduit_cage": {
                    mobNameForFileAndMap.setBoth("conduit", "conduit_cage");
                    break;
                }
                case "conduit_eye": {
                    mobNameForFileAndMap.setBoth("conduit", "conduit_eye");
                    break;
                }
                case "conduit_shell": {
                    mobNameForFileAndMap.setBoth("conduit", "conduit_shell");
                    break;
                }
                case "conduit_wind": {
                    mobNameForFileAndMap.setBoth("conduit", "conduit_wind");
                    break;
                }
                case "decorated_pot_base": {
                    mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_base");
                    break;
                }
                case "decorated_pot_sides": {
                    mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_sides");
                    break;
                }
                case "book": {
                    if (this.currentSpecifiedModelLoading.equals("enchanting_book")) {
                        mobNameForFileAndMap.setBoth("enchanting_book", "book");
                        break;
                    }
                    mobNameForFileAndMap.setBoth("lectern_book", "book");
                    break;
                }
                case "chest": {
                    if (this.currentSpecifiedModelLoading.equals("ender_chest")) {
                        mobNameForFileAndMap.setBoth("ender_chest", "chest");
                        break;
                    }
                    if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                        mobNameForFileAndMap.setBoth("trapped_chest", "chest");
                        break;
                    }
                    mobNameForFileAndMap.setBoth("chest", "chest");
                    break;
                }
                case "double_chest_left": {
                    if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                        mobNameForFileAndMap.setBoth("trapped_chest_large", "double_chest_left");
                        break;
                    }
                    mobNameForFileAndMap.setBoth("chest_large", "double_chest_left");
                    break;
                }
                case "double_chest_right": {
                    if (this.currentSpecifiedModelLoading.equals("trapped_chest")) {
                        mobNameForFileAndMap.setBoth("trapped_chest_large", "double_chest_right");
                        break;
                    }
                    mobNameForFileAndMap.setBoth("chest_large", "double_chest_right");
                    break;
                }
                case "shulker": {
                    if (this.currentSpecifiedModelLoading.equals("shulker_box")) {
                        mobNameForFileAndMap.setBoth("shulker_box");
                        this.currentSpecifiedModelLoading = "";
                        break;
                    }
                    mobNameForFileAndMap.setBoth("shulker");
                    break;
                }
                default: {
                    if (!mobNameForFileAndMap.getfileName().contains("/") || !layer.m_171124_().equals("main")) break;
                    if (mobNameForFileAndMap.getfileName().startsWith("hanging_sign/")) {
                        mobNameForFileAndMap.setBoth("hanging_sign");
                        break;
                    }
                    if (mobNameForFileAndMap.getfileName().startsWith("sign/")) {
                        mobNameForFileAndMap.setBoth("sign");
                        break;
                    }
                    if (mobNameForFileAndMap.getfileName().startsWith("chest_boat/")) {
                        if (mobNameForFileAndMap.getfileName().startsWith("chest_boat/bamboo")) {
                            mobNameForFileAndMap.setBoth("chest_raft");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("chest_boat");
                        break;
                    }
                    if (!mobNameForFileAndMap.getfileName().startsWith("boat/")) break;
                    if (mobNameForFileAndMap.getfileName().startsWith("boat/bamboo")) {
                        mobNameForFileAndMap.setBoth("raft");
                        break;
                    }
                    mobNameForFileAndMap.setBoth("boat");
                }
            }
        }
        if (printing) {
            System.out.println(" > EMF try to find a model for: " + mobNameForFileAndMap);
        }
        Map<String, String> optifinePartNameMap = EMFOptiFinePartNameMappings.getMapOf(mobNameForFileAndMap.getMapId(), root);
        if (printing) {
            System.out.println(" >> EMF trying to find: optifine/cem/" + mobNameForFileAndMap + ".jem");
        }
        String jemName = mobNameForFileAndMap + ".jem";
        CemDirectoryApplier variantDirectoryApplier = EMFManager.getResourceCemDirectoryApplierOrNull(mobNameForFileAndMap + ".properties", mobNameForFileAndMap.getfileName());
        EMFJemData jemData = EMFManager.getJemData(jemName, mobNameForFileAndMap);
        if (jemData != null || variantDirectoryApplier != null) {
            HashSet<String> optifinePartNames = new HashSet<String>();
            optifinePartNameMap.forEach((optifine, vanilla) -> {
                if (!optifine.equals("EMPTY")) {
                    optifinePartNames.add((String)vanilla);
                }
            });
            EMFModelPartRoot emfRoot = new EMFModelPartRoot(mobNameForFileAndMap, variantDirectoryApplier, root, optifinePartNames, new HashMap<String, EMFModelPartVanilla>());
            if (jemData != null) {
                emfRoot.addVariantOfJem(jemData, 1);
                emfRoot.setVariantStateTo(1);
                this.setupAnimationsFromJemToModel(jemData, emfRoot, 1);
            }
            lastCreatedRootModelPart = emfRoot;
            return emfRoot;
        }
        if (printing) {
            System.out.println(" > Vanilla model used for: " + mobNameForFileAndMap);
        }
        return root;
    }

    private void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartRoot emfRootPart, int variantNum) {
        boolean printing = EMFConfig.getConfig().logModelCreationData;
        Object2ObjectOpenHashMap allPartsBySingleAndFullHeirachicalId = new Object2ObjectOpenHashMap();
        allPartsBySingleAndFullHeirachicalId.put((Object)"EMF_root", (Object)emfRootPart);
        allPartsBySingleAndFullHeirachicalId.putAll(emfRootPart.getAllChildPartsAsAnimationMap("", variantNum, EMFOptiFinePartNameMappings.getMapOf(emfRootPart.modelName.getMapId(), null)));
        Object2ObjectLinkedOpenHashMap emfAnimationsByPartName = new Object2ObjectLinkedOpenHashMap();
        if (printing) {
            System.out.println(" > finalAnimationsForModel =");
            jemData.allTopLevelAnimationsByVanillaPartName.forEach((part, anims) -> anims.forEach((key, expression) -> System.out.println(" >> " + key + " = " + expression)));
        }
        jemData.allTopLevelAnimationsByVanillaPartName.forEach((part, anims) -> {
            Object2ObjectLinkedOpenHashMap thisPartAnims = new Object2ObjectLinkedOpenHashMap();
            anims.forEach((animKey, animationExpression) -> {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.EMFModMessage("parsing animation value: [" + animKey + "]");
                }
                String modelId = animKey.split("\\.")[0];
                String modelVariable = animKey.split("\\.")[1];
                EMFModelOrRenderVariable thisVariable = EMFModelOrRenderVariable.get(modelVariable);
                if (thisVariable == null) {
                    thisVariable = EMFModelOrRenderVariable.getRenderVariable(animKey);
                }
                EMFModelPart thisPart = "render".equals(modelId) ? null : EMFManager.getModelFromHierarchichalId(modelId, (Map<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                thisPartAnims.put(animKey, (Object)new EMFAnimation(thisPart, thisVariable, (String)animKey, (String)animationExpression, jemData.fileName));
            });
            emfAnimationsByPartName.put(part, (Object)thisPartAnims);
        });
        this.isAnimationValidationPhase = true;
        emfAnimationsByPartName.forEach((part, animMap) -> {
            ObjectBidirectionalIterator animMapIterate = animMap.entrySet().iterator();
            while (animMapIterate.hasNext()) {
                Map.Entry anim = (Map.Entry)animMapIterate.next();
                if (anim.getValue() != null) {
                    ((EMFAnimation)anim.getValue()).initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)animMap, (Object2ObjectOpenHashMap<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                    if (((EMFAnimation)anim.getValue()).isValid()) continue;
                    EMFUtils.EMFModWarn("animations was invalid: " + ((EMFAnimation)anim.getValue()).animKey + " = " + ((EMFAnimation)anim.getValue()).expressionString);
                    animMapIterate.remove();
                    continue;
                }
                animMapIterate.remove();
            }
        });
        this.isAnimationValidationPhase = false;
        emfRootPart.receiveAnimations(variantNum, (Object2ObjectLinkedOpenHashMap<String, Object2ObjectLinkedOpenHashMap<String, EMFAnimation>>)emfAnimationsByPartName);
    }

    public void doVariantCheckFor(EMFModelPartRoot cannonRoot) {
        EMFEntity entity = EMFAnimationHelper.getEMFEntity();
        if (entity != null && cannonRoot.variantDirectoryApplier != null && this.cache_UUIDDoUpdating.getBoolean((Object)entity.getUuid()) && ETFApi.getETFConfigObject().textureUpdateFrequency_V2 != ETFConfig.UpdateFrequency.Never) {
            String mobName = cannonRoot.modelName.getfileName();
            UUIDAndMobTypeKey key = new UUIDAndMobTypeKey(entity.getUuid(), entity.getTypeString());
            long randomizer = (long)ETFApi.getETFConfigObject().textureUpdateFrequency_V2.getDelay() * 20L;
            if (System.currentTimeMillis() % randomizer == (long)Math.abs(entity.getUuid().hashCode()) % randomizer) {
                ETFApi.ETFRandomTexturePropertyInstance emfProperty;
                if (cannonRoot.variantTester == null) {
                    ResourceLocation propertyID = new ResourceLocation(cannonRoot.variantDirectoryApplier.getThisDirectoryOfFilename(mobName + ".properties"));
                    if (Minecraft.m_91087_().m_91098_().m_213713_(propertyID).isPresent()) {
                        cannonRoot.variantTester = ETFApi.readRandomPropertiesFileAndReturnTestingObject2((ResourceLocation)propertyID, (String)"models");
                    } else {
                        EMFUtils.EMFModWarn("no property" + propertyID);
                        cannonRoot.variantDirectoryApplier = null;
                        return;
                    }
                }
                if ((emfProperty = cannonRoot.variantTester) != null) {
                    int suffix = entity.entity() == null ? emfProperty.getSuffixForBlockEntity(entity.getBlockEntity(), entity.getUuid(), this.cache_UUIDDoUpdating.containsKey((Object)entity.getUuid()), this.cache_UUIDDoUpdating) : emfProperty.getSuffixForEntity(entity.entity(), this.cache_UUIDDoUpdating.containsKey((Object)entity.getUuid()), this.cache_UUIDDoUpdating);
                    if (suffix > 1) {
                        if (!cannonRoot.allKnownStateVariants.containsKey(suffix)) {
                            EMFJemData jemData;
                            String jemName = cannonRoot.variantDirectoryApplier.getThisDirectoryOfFilename(mobName + suffix + ".jem");
                            if (EMFConfig.getConfig().logModelCreationData) {
                                System.out.println(" >> first time load of : " + jemName);
                            }
                            if ((jemData = EMFManager.getJemDataWithDirectory(jemName, cannonRoot.modelName)) != null) {
                                cannonRoot.addVariantOfJem(jemData, suffix);
                                cannonRoot.setVariantStateTo(suffix);
                                this.setupAnimationsFromJemToModel(jemData, cannonRoot, suffix);
                            } else {
                                System.out.println("invalid jem: " + jemName);
                            }
                        }
                        cannonRoot.setVariantStateTo(suffix);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, suffix);
                    } else {
                        cannonRoot.setVariantStateTo(1);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, 1);
                    }
                } else {
                    cannonRoot.variantDirectoryApplier = null;
                    cannonRoot.setVariantStateTo(1);
                }
            } else {
                cannonRoot.setVariantStateTo(this.cache_UUIDAndTypeToCurrentVariantInt.getInt((Object)key));
            }
        } else {
            cannonRoot.setVariantStateTo(1);
        }
    }

    public static interface CemDirectoryApplier {
        public static CemDirectoryApplier getEMF() {
            return fileName -> "emf/cem/" + fileName;
        }

        public static CemDirectoryApplier getEMF_Mob(String mobname) {
            return fileName -> "emf/cem/" + mobname + "/" + fileName;
        }

        public static CemDirectoryApplier getCEM() {
            return fileName -> "optifine/cem/" + fileName;
        }

        public static CemDirectoryApplier getCem_Mob(String mobName) {
            return fileName -> "optifine/cem/" + mobName + "/" + fileName;
        }

        public String getThisDirectoryOfFilename(String var1);
    }

    private record UUIDAndMobTypeKey(UUID uuid, String entityType) {
    }
}

