/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFPartData;

public class EMFUtils {
    public static void EMFOverrideMessage(String originalClass, String overriddenClassFromMod, boolean wasReverted) {
        LogManager.getLogger().warn("[Entity Model Features]: Entity model [" + originalClass + "] has been overridden by [" + overriddenClassFromMod + "] likely from a mod.");
        if (wasReverted) {
            LogManager.getLogger().warn("[Entity Model Features]: Prevent model overrides option is enabled! EMF will attempt to revert the new model [" + overriddenClassFromMod + "] back into the original model [" + originalClass + "]. THIS MAY HAVE UNINTENDED EFFECTS ON THE OTHER MOD, DISABLE THIS EMF SETTING IF IT CAUSES CRASHES!");
        }
    }

    public static void EMFModMessage(String message) {
        EMFUtils.EMFModMessage(message, false);
    }

    public static void EMFModMessage(String message, boolean inChat) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)("\u00a76[Entity Model Features]\u00a77: " + message)), false);
            } else {
                LogManager.getLogger().info("[Entity Model Features]: " + message);
            }
        } else {
            LogManager.getLogger().info("[Entity Model Features]: " + message);
        }
    }

    public static void EMFModWarn(String message) {
        EMFUtils.EMFModWarn(message, false);
    }

    public static void EMFModWarn(String message, boolean inChat) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)("\u00a76[Entity Model Features]\u00a77: " + message)), false);
            } else {
                LogManager.getLogger().warn("[Entity Model Features]: " + message);
            }
        } else {
            LogManager.getLogger().warn("[Entity Model Features]: " + message);
        }
    }

    public static void EMFModError(String message) {
        EMFUtils.EMFModError(message, false);
    }

    public static void EMFModError(String message, boolean inChat) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)("\u00a76[Entity Model Features]\u00a77: " + message)), false);
            } else {
                LogManager.getLogger().error("[Entity Model Features]: " + message);
            }
        } else {
            LogManager.getLogger().error("[Entity Model Features]: " + message);
        }
    }

    @Nullable
    public static EMFPartData EMFReadModelPart(String pathOfJpm, String filePath) {
        pathOfJpm = Objects.requireNonNullElse(filePath, "optifine/cem/") + (String)pathOfJpm;
        if (!((String)pathOfJpm).endsWith(".jpm")) {
            pathOfJpm = (String)pathOfJpm + ".jpm";
        }
        try {
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation((String)pathOfJpm));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.EMFModMessage("jpm failed " + (String)pathOfJpm + " does not exist", false);
                }
                return null;
            }
            Resource jpmResource = (Resource)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jpmResource.m_215507_()));
            EMFPartData jpm = (EMFPartData)gson.fromJson((Reader)reader, EMFPartData.class);
            reader.close();
            return jpm;
        }
        catch (Exception e) {
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.EMFModMessage("jpm failed " + e, false);
            }
            return null;
        }
    }

    public static String getIdUnique(Set<String> known, String desired) {
        while (known.contains(desired) || ((String)desired).isBlank()) {
            desired = (String)desired + "#";
        }
        return desired;
    }
}

