/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain;

import com.leclowndu93150.particlerain.ModConfig;
import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRegistry;
import com.leclowndu93150.particlerain.WeatherParticleSpawner;
import com.leclowndu93150.particlerain.particle.DustMoteParticle;
import com.leclowndu93150.particlerain.particle.DustParticle;
import com.leclowndu93150.particlerain.particle.FogParticle;
import com.leclowndu93150.particlerain.particle.GroundFogParticle;
import com.leclowndu93150.particlerain.particle.RainParticle;
import com.leclowndu93150.particlerain.particle.RippleParticle;
import com.leclowndu93150.particlerain.particle.ShrubParticle;
import com.leclowndu93150.particlerain.particle.SnowParticle;
import com.leclowndu93150.particlerain.particle.StreakParticle;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientStuff {
    public static final String MOD_ID = "particlerain";
    public static ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    public static boolean previousBiomeTintOption;
    public static boolean previousUseResolutionOption;
    public static int previousResolutionOption;
    public static IntUnaryOperator desaturateOperation;

    static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)ParticleRegistry.RAIN.get(), RainParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.SNOW.get(), SnowParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.DUST_MOTE.get(), DustMoteParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.DUST.get(), DustParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.SHRUB.get(), ShrubParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.FOG.get(), FogParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.GROUND_FOG.get(), GroundFogParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.RIPPLE.get(), RippleParticle.DefaultFactory::new);
        event.register((ParticleType)ParticleRegistry.STREAK.get(), StreakParticle.DefaultFactory::new);
    }

    static InteractionResult saveListener(ConfigHolder<ModConfig> modConfigConfigHolder, ModConfig modConfig) {
        if (ClientStuff.config.biomeTint != previousBiomeTintOption || ClientStuff.config.ripple.useResourcepackResolution != previousUseResolutionOption || ClientStuff.config.ripple.resolution != previousResolutionOption) {
            Minecraft.m_91087_().m_91391_();
        }
        return InteractionResult.PASS;
    }

    public static void applyWaterTint(TextureSheetParticle particle, ClientLevel clientLevel, BlockPos blockPos) {
        Color waterColor = new Color(BiomeColors.m_108811_((BlockAndTintGetter)clientLevel, (BlockPos)blockPos));
        Color fogColor = new Color(((Biome)clientLevel.m_204166_(blockPos).m_203334_()).m_47539_());
        float rCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.m_107253_(rCol, gCol, bCol);
    }

    public static void applyToAllPixels(NativeImage image, IntUnaryOperator operator) {
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                int rgba = Integer.rotateLeft(image.m_84985_(x, y), 8);
                rgba = operator.applyAsInt(rgba);
                image.m_84988_(x, y, Integer.rotateRight(rgba, 8));
            }
        }
    }

    public static NativeImage loadTexture(ResourceLocation resourceLocation) throws IOException {
        NativeImage nativeImage;
        Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(resourceLocation);
        try (InputStream inputStream = resource.m_215507_();){
            nativeImage = NativeImage.m_85058_((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static TextureAtlasSprite.Info createInfo(ResourceLocation location, NativeImage image) {
        return new TextureAtlasSprite.Info(location, image.m_84982_(), image.m_85084_(), AnimationMetadataSection.f_119012_);
    }

    public static void desaturateImage(NativeImage image) {
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                int pixel = image.m_84985_(x, y);
                int r = NativeImage.m_85085_((int)pixel);
                int g = NativeImage.m_85103_((int)pixel);
                int b = NativeImage.m_85119_((int)pixel);
                int a = NativeImage.m_84983_((int)pixel);
                int gray = (int)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
                image.m_84988_(x, y, NativeImage.m_84992_((int)a, (int)gray, (int)gray, (int)gray));
            }
        }
    }

    public static double yLevelWindAdjustment(double y) {
        return Mth.m_14008_((double)0.01, (double)1.0, (double)((y - 64.0) / 40.0));
    }

    static {
        desaturateOperation = rgba -> {
            Color col = new Color(rgba, true);
            int gray = Math.max(Math.max(col.getRed(), col.getGreen()), col.getBlue());
            return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
        };
    }

    @Mod.EventBusSubscriber(modid="particlerain", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public class ClientEvents {
        @SubscribeEvent
        public static void onTextureStitch(TextureStitchEvent.Pre event) {
            int idx;
            if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
                return;
            }
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
            for (idx = 0; idx < 4; ++idx) {
                try {
                    if (ParticleRainClient.config.biomeTint) {
                        NativeImage rainTexture = ClientStuff.loadTexture(new ResourceLocation(ClientStuff.MOD_ID, "textures/particle/rain" + idx + ".png"));
                        ClientStuff.applyToAllPixels(rainTexture, desaturateOperation);
                    }
                    ClientEvents.addSprite(event, "rain" + idx);
                    ClientEvents.addSprite(event, "snow" + idx);
                    ClientEvents.addSprite(event, "splash_" + idx);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (idx = 0; idx < 8; ++idx) {
                ClientEvents.addSprite(event, "ripple_" + idx);
            }
            for (String texture : new String[]{"streak", "ground_fog", "fog_dithered", "dust"}) {
                ClientEvents.addSprite(event, texture);
            }
        }

        private static void addSprite(TextureStitchEvent.Pre event, String path) {
            event.addSprite(new ResourceLocation(ClientStuff.MOD_ID, "particle/" + path));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ModClientForgeEvents {
        @SubscribeEvent
        public static void registerClientCommands(RegisterClientCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)ClientStuff.MOD_ID).executes(ctx -> {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Particle count: %d/%d", ParticleRainClient.particleCount, ParticleRainClient.config.maxParticleAmount)), false);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Fog density: %d/%d", ParticleRainClient.fogCount, ParticleRainClient.config.groundFog.density)), false);
                return 0;
            }));
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft;
            if (event.phase == TickEvent.Phase.END && !(minecraft = Minecraft.m_91087_()).m_91104_() && minecraft.f_91073_ != null && minecraft.m_91288_() != null) {
                WeatherParticleSpawner.update(minecraft.f_91073_, minecraft.m_91288_(), minecraft.m_91297_());
            }
        }

        @SubscribeEvent
        public void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
        }
    }
}

