/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

@OnlyIn(value=Dist.CLIENT)
public final class WeatherParticleSpawner {
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    private static void spawnParticle(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        Biome.Precipitation precipitation;
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        if (ParticleRainClient.particleCount > ParticleRainClient.config.maxParticleAmount) {
            return;
        }
        if (!ParticleRainClient.config.spawnAboveClouds && y > (double)ParticleRainClient.config.cloudHeight) {
            y = ParticleRainClient.config.cloudHeight;
        }
        if (ParticleRainClient.config.doFogParticles && level.f_46441_.m_188501_() < (float)ParticleRainClient.config.fog.density / 100.0f) {
            level.m_7106_((ParticleOptions)ParticleRegistry.FOG.get(), x, y, z, 0.0, 0.0, 0.0);
        }
        if ((precipitation = ((Biome)biome.m_203334_()).m_47530_()) == Biome.Precipitation.RAIN) {
            int height;
            if (ParticleRainClient.config.doGroundFogParticles && ParticleRainClient.fogCount < ParticleRainClient.config.groundFog.density && (height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z)) <= ParticleRainClient.config.groundFog.spawnHeight && height >= ParticleRainClient.config.groundFog.spawnHeight - 4 && level.m_6425_(new BlockPos(x, (double)(height - 1), z)).m_76178_()) {
                level.m_7106_((ParticleOptions)ParticleRegistry.GROUND_FOG.get(), x, (double)((float)height + level.f_46441_.m_188501_()), z, 0.0, 0.0, 0.0);
            }
            if (ParticleRainClient.config.doRainParticles && level.f_46441_.m_188501_() < (float)ParticleRainClient.config.rain.density / 100.0f) {
                level.m_7106_((ParticleOptions)ParticleRegistry.RAIN.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (precipitation == Biome.Precipitation.SNOW && ParticleRainClient.config.doSnowParticles) {
            if (level.f_46441_.m_188501_() < (float)ParticleRainClient.config.snow.density / 100.0f) {
                level.m_7106_((ParticleOptions)ParticleRegistry.SNOW.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (WeatherParticleSpawner.doesThisBlockHaveDustBlowing(precipitation, level, new BlockPos(x, y, z), biome)) {
            if (ParticleRainClient.config.sand.spawnOnGround) {
                y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
            }
            if (ParticleRainClient.config.doSandParticles && level.f_46441_.m_188501_() < (float)ParticleRainClient.config.sand.density / 100.0f) {
                level.m_7106_((ParticleOptions)ParticleRegistry.DUST.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            if (ParticleRainClient.config.doShrubParticles && level.f_46441_.m_188501_() < (float)ParticleRainClient.config.shrub.density / 100.0f) {
                level.m_7106_((ParticleOptions)ParticleRegistry.SHRUB.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void update(ClientLevel level, Entity entity, float partialTicks) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        if (level.m_46471_() || ParticleRainClient.config.alwaysRaining) {
            int density = level.m_46470_() ? (ParticleRainClient.config.alwaysRaining ? ParticleRainClient.config.particleStormDensity : (int)((float)ParticleRainClient.config.particleStormDensity * level.m_46722_(partialTicks))) : (ParticleRainClient.config.alwaysRaining ? ParticleRainClient.config.particleDensity : (int)((float)ParticleRainClient.config.particleDensity * level.m_46722_(partialTicks)));
            Random rand = new Random();
            for (int pass = 0; pass < density; ++pass) {
                float theta = (float)(Math.PI * 2 * (double)rand.nextFloat());
                float phi = (float)Math.acos(2.0f * rand.nextFloat() - 1.0f);
                double x = (double)((float)ParticleRainClient.config.particleRadius * Mth.m_14031_((float)phi)) * Math.cos(theta);
                double y = (double)((float)ParticleRainClient.config.particleRadius * Mth.m_14031_((float)phi)) * Math.sin(theta);
                double z = (float)ParticleRainClient.config.particleRadius * Mth.m_14089_((float)phi);
                pos.m_122169_(x + entity.m_20185_(), y + entity.m_20186_(), z + entity.m_20189_());
                if (level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) > pos.m_123342_()) continue;
                WeatherParticleSpawner.spawnParticle(level, (Holder<Biome>)level.m_204166_((BlockPos)pos), (float)pos.m_123341_() + rand.nextFloat(), (float)pos.m_123342_() + rand.nextFloat(), (float)pos.m_123343_() + rand.nextFloat());
            }
        }
    }

    @Nullable
    public static SoundEvent getBiomeSound(BlockPos blockPos, boolean above) {
        Holder biome = Minecraft.m_91087_().f_91073_.m_204166_(blockPos);
        Biome.Precipitation precipitation = ((Biome)biome.m_203334_()).m_47530_();
        if (precipitation == Biome.Precipitation.RAIN && ParticleRainClient.config.doRainSounds) {
            return above ? SoundEvents.f_12542_ : SoundEvents.f_12541_;
        }
        if (precipitation == Biome.Precipitation.SNOW && ParticleRainClient.config.doSnowSounds) {
            return above ? (SoundEvent)ParticleRegistry.WEATHER_SNOW_ABOVE.get() : (SoundEvent)ParticleRegistry.WEATHER_SNOW.get();
        }
        if (WeatherParticleSpawner.doesThisBlockHaveDustBlowing(precipitation, Minecraft.m_91087_().f_91073_, blockPos, (Holder<Biome>)biome) && ParticleRainClient.config.doSandSounds) {
            return above ? (SoundEvent)ParticleRegistry.WEATHER_SANDSTORM_ABOVE.get() : (SoundEvent)ParticleRegistry.WEATHER_SANDSTORM.get();
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(Biome.Precipitation precipitation, ClientLevel level, BlockPos blockPos, Holder<Biome> biome) {
        return precipitation == Biome.Precipitation.NONE && level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_7495_()).m_204336_(TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)ResourceLocation.m_135820_((String)ParticleRainClient.config.sand.matchTags))) && (double)((Biome)biome.m_203334_()).m_47554_() > 0.25;
    }
}

