/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShrubParticle
extends WeatherParticle {
    protected ShrubParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.f_107663_ = 0.5f;
        this.f_107225_ = 80;
        this.f_107226_ = ParticleRainClient.config.shrub.gravity;
        this.f_107215_ = ParticleRainClient.config.sand.windStrength;
        this.f_107217_ = ParticleRainClient.config.sand.windStrength;
        if (ParticleRainClient.config.sand.spawnOnGround) {
            this.f_107216_ = 0.1f;
        }
        this.f_107219_ = true;
        BlockState blockState = level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(x, y, z)));
        if (blockState.m_60713_(Blocks.f_50036_) || blockState.m_204336_(BlockTags.f_13037_) || blockState.m_204336_(BlockTags.f_13040_)) {
            ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
            this.m_108337_(Minecraft.m_91087_().m_91291_().m_174264_(itemStack, (Level)level, null, 0).m_6160_());
            int colorInt = BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            Color color = new Color(colorInt);
            this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        } else {
            if ((double)level.f_46441_.m_188501_() < 0.9) {
                this.m_107274_();
            }
            this.m_108337_(Minecraft.m_91087_().m_91291_().m_174264_(new ItemStack((ItemLike)Items.f_41866_), (Level)level, null, 0).m_6160_());
        }
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.removeIfObstructed();
        if (!this.f_107208_.m_6425_((BlockPos)this.pos).m_76178_()) {
            this.shouldFadeOut = true;
            this.f_107226_ = 0.0f;
        } else {
            this.f_107215_ = 0.2;
            this.f_107217_ = 0.2;
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += ParticleRainClient.config.shrub.rotationAmount;
        if (this.f_107218_) {
            this.f_107216_ = ParticleRainClient.config.shrub.bounciness;
        }
    }

    @Override
    public void fadeIn() {
        if (this.f_107224_ < 10) {
            this.f_107230_ = (float)this.f_107224_ * 1.0f / 10.0f;
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vec3 camPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        float angle = (float)Math.atan2(this.f_107215_, this.f_107217_);
        Quaternion quaternion = Vector3f.f_122225_.m_122270_(angle);
        Quaternion quat1 = new Quaternion(0.0f, 0.0f, 1.0f, 0.0f);
        Quaternion quat2 = Vector3f.f_122225_.m_122240_(90.0f);
        quat1.m_80148_(quaternion);
        quat1.m_80148_(Vector3f.f_122223_.m_122270_(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_)));
        quat2.m_80148_(quaternion);
        quat2.m_80148_(Vector3f.f_122227_.m_122270_(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_)));
        quat1 = this.flipItTurnwaysIfBackfaced(quat1, new Vector3f(x, y, z));
        quat2 = this.flipItTurnwaysIfBackfaced(quat2, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quat1, x, y, z, tickPercentage);
        this.renderRotatedQuad(vertexConsumer, quat2, x, y, z, tickPercentage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

