/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class TextureProcessor {
    public static void main(String[] args) {
        String outputPath = "assets/particlerain/textures/particle/";
        TextureProcessor.processTexture("rain.png", "rain", outputPath, 4);
        TextureProcessor.processTexture("snow.png", "snow", outputPath, 4);
    }

    private static void processTexture(String inputFile, String baseName, String outputPath, int frames) {
        try {
            File input = new File(inputFile);
            System.out.println("Processing: " + input.getAbsolutePath());
            BufferedImage source = ImageIO.read(input);
            int frameWidth = source.getWidth();
            int frameHeight = source.getHeight() / frames;
            Files.createDirectories(Paths.get(outputPath, new String[0]), new FileAttribute[0]);
            for (int i = 0; i < frames; ++i) {
                BufferedImage frame = new BufferedImage(frameWidth, frameHeight, 2);
                for (int x = 0; x < frameWidth; ++x) {
                    for (int y = 0; y < frameHeight; ++y) {
                        int rgb = source.getRGB(x, i * frameHeight + y);
                        frame.setRGB(x, y, rgb);
                    }
                }
                File output = new File(outputPath + baseName + i + ".png");
                ImageIO.write((RenderedImage)frame, "PNG", output);
                System.out.println("Created: " + output.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

