/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.world.gen.structures;

import com.mojang.serialization.Codec;
import com.ninni.twigs.registry.TwigsStructureTypes;
import com.ninni.twigs.world.gen.structures.ObeliskGenerator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ObeliskStructure
extends Structure {
    public static final Codec<ObeliskStructure> CODEC = ObeliskStructure.m_226607_(ObeliskStructure::new);

    public ObeliskStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        if (!ObeliskStructure.canGenerate(generationContext, generationContext.f_226628_().m_151394_(0))) {
            return Optional.empty();
        }
        return ObeliskStructure.m_226585_((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, collector -> this.addPieces((StructurePiecesBuilder)collector, generationContext));
    }

    public static boolean canGenerate(Structure.GenerationContext context, BlockPos blockPos) {
        boolean flag = false;
        int range = 5;
        for (int x = -range; x <= range; ++x) {
            block1: for (int z = -range; z <= range; ++z) {
                BlockPos structurePos = blockPos.m_7918_(x, 0, z);
                NoiseColumn verticalBlockSample = context.f_226622_().m_214184_(structurePos.m_123341_(), structurePos.m_123343_(), context.f_226629_(), context.f_226624_());
                for (int y = 80; y > context.f_226622_().m_6337_(); --y) {
                    if (!verticalBlockSample.m_183556_(y - 1).m_60815_() || !verticalBlockSample.m_183556_(y).m_60795_() || !verticalBlockSample.m_183556_(y + 14).m_60795_()) continue;
                    flag = true;
                    continue block1;
                }
            }
        }
        return flag;
    }

    public void addPieces(StructurePiecesBuilder collector, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        BlockPos pos = new BlockPos(chunkPos.m_45604_(), this.getHeight(random), chunkPos.m_45605_());
        ObeliskGenerator.addPieces(context.f_226625_(), pos, Rotation.m_221990_((RandomSource)random), collector);
    }

    private int getHeight(WorldgenRandom random) {
        return random.m_188503_(60) + 40;
    }

    public StructureType<?> m_213658_() {
        return TwigsStructureTypes.OBELISK;
    }
}

