/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.crafting.condition.VanillaCrateEnabledCondition;
import vectorwing.farmersdelight.common.entity.RottenTomatoEntity;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.world.WildCropGeneration;

public class CommonSetup {
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CommonSetup.registerCompostables();
            CommonSetup.registerDispenserBehaviors();
            CommonSetup.registerAnimalFeeds();
            CommonSetup.registerStackSizeOverrides();
            WildCropGeneration.registerWildCropGeneration();
        });
        ModAdvancements.register();
        CraftingHelper.register((IConditionSerializer)new VanillaCrateEnabledCondition.Serializer());
    }

    public static void registerStackSizeOverrides() {
        if (!((Boolean)Configuration.ENABLE_STACKABLE_SOUP_ITEMS.get()).booleanValue()) {
            return;
        }
        ((List)Configuration.SOUP_ITEM_LIST.get()).forEach(key -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key));
            if (item instanceof BowlFoodItem) {
                ObfuscationReflectionHelper.setPrivateValue(Item.class, (Object)item, (Object)16, (String)"f_41370_");
            }
        });
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.ROTTEN_TOMATO.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level pLevel, Position pPosition, ItemStack pStack) {
                return new RottenTomatoEntity(pLevel, pPosition.m_7096_(), pPosition.m_7098_(), pPosition.m_7094_());
            }
        });
    }

    public static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TREE_BARK.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.STRAW.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_PANICLE.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SANDY_SHRUB.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PUMPKIN_SLICE.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE_LEAF.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.KELP_ROLL_SLICE.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.ONION.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_CABBAGES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_ONIONS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_TOMATOES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_CARROTS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_POTATOES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_BEETROOTS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_RICE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PIE_CRUST.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_BALE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.HONEY_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.APPLE_PIE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHOCOLATE_PIE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RAW_PASTA.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.ROTTEN_TOMATO.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.KELP_ROLL.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.APPLE_PIE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHOCOLATE_PIE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.DUMPLINGS.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.STUFFED_PUMPKIN_BLOCK.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RED_MUSHROOM_COLONY.get()), 1.0f);
    }

    public static void registerAnimalFeeds() {
        Ingredient newChickenFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_SEEDS.get(), (ItemLike)ModItems.TOMATO_SEEDS.get(), (ItemLike)ModItems.RICE.get()});
        Chicken.f_28233_ = new CompoundIngredient(Arrays.asList(Chicken.f_28233_, newChickenFood)){};
        Ingredient newPigFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.TOMATO.get()});
        Pig.f_29458_ = new CompoundIngredient(Arrays.asList(Pig.f_29458_, newPigFood)){};
        Collections.addAll(Parrot.f_29357_, (Item)ModItems.CABBAGE_SEEDS.get(), (Item)ModItems.TOMATO_SEEDS.get(), (Item)ModItems.RICE.get());
    }
}

