/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.starfish_studios.another_furniture.block.ShelfBlock;
import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShelfBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)ShelfBlock.FACING);
        float rotation = -direction.m_122435_() + 180.0f;
        NonNullList<ItemStack> items = blockEntity.getItems();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.18, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        for (int j = 0; j < items.size(); ++j) {
            ItemStack stack = (ItemStack)items.get(j);
            if (stack.m_41619_()) continue;
            int renderCount = this.getAmount(stack.m_41613_());
            for (int i = 0; i < renderCount; ++i) {
                float fx = -0.10375f * (float)(i - 1) * 0.5f % 0.09f;
                float fy = -0.04375f * (float)(i - 1) * 0.5f % 0.09f;
                float fz = -0.05375f * (float)(i - 1) * 0.5f % 0.09f;
                poseStack.m_85836_();
                poseStack.m_85837_(0.15 - 0.4 * (double)(j % 2), 0.0, -0.225 + 0.4 * (double)(j / 2));
                poseStack.m_85837_((double)fx, (double)fy, (double)fz);
                poseStack.m_85841_(0.375f, 0.375f, 0.375f);
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, packedLight, packedOverlay, poseStack, bufferSource, 0);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    public int getAmount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }
}

