/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;

    public static void renderGameOverlayEvent(PoseStack poseStack) {
        int yPlacement;
        if (!showWeather && !showTime) {
            return;
        }
        if (!ModConfig.get().clock_enable) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Object time = ClockOverlay.getTime(mc.f_91073_.m_46468_());
        if (((String)time).length() == 4) {
            time = " " + (String)time;
        }
        int xOffset = 3;
        int iconOffset = 0;
        int textureOffset = 7;
        int tooltipSize = 16;
        int textYPlacement = yPlacement = ModConfig.get().clock_vertical_position;
        if (showWeather) {
            if (showTime) {
                iconOffset = 20;
            }
            textureOffset = 111;
            tooltipSize = 21;
            textYPlacement += 2;
        }
        int fontWidth = mc.f_91062_.m_92895_((String)time) + iconOffset;
        if (mc.f_91074_ == null) {
            return;
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.f_91074_)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
            textYPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
        }
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayHelpers.TEXTURE);
        OverlayHelpers.renderBackground(poseStack, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, textureOffset, tooltipSize);
        if (showTime) {
            GuiComponent.m_93236_((PoseStack)poseStack, (Font)mc.f_91062_, (String)time, (int)(xPlacement - xOffset + iconOffset), (int)textYPlacement, (int)0xE0E0E0);
        }
        if (showWeather) {
            int spriteOffset = ClockOverlay.getWeather((Player)mc.f_91074_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayHelpers.TEXTURE);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(xPlacement - xOffset - 1), (int)(yPlacement - 1), (int)0, (float)spriteOffset, (float)95.0f, (int)16, (int)16, (int)256, (int)256);
        }
    }

    public static int getWeather(Player player) {
        Level level = player.f_19853_;
        Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
        long time = level.m_46468_() % 24000L;
        Biome.Precipitation precipitation = biome.m_47530_();
        boolean snows = biome.m_198904_(player.m_20183_());
        if (!level.m_6042_().f_63858_()) {
            return 124;
        }
        if (level.m_46470_()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 76;
        }
        if (level.m_46471_()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 60;
        }
        if (time >= 12500L && time <= 13500L) {
            return 30;
        }
        if (time >= 13500L && time <= 22500L) {
            return 46;
        }
        if (time >= 23000L || time <= 300L) {
            return 15;
        }
        return 0;
    }

    public static String getTime(float dayTime) {
        int time = (int)(dayTime + 6000.0f) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!Boolean.valueOf(ModConfig.get().clock_24_hour).booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return h + ":" + (m < 10 ? "0" : "") + m + a;
    }
}

