/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.compat.MapAtlasesCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class CompassOverlay {
    public static boolean showXZ = false;
    public static boolean showY = false;

    public static void renderGameOverlayEvent(PoseStack poseStack) {
        if (!showXZ && !showY) {
            return;
        }
        if (!ModConfig.get().compass_enable) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (OverlayHelpers.debug(mc)) {
            return;
        }
        ArrayList<String> coords = new ArrayList<String>();
        if (mc.f_91074_ == null) {
            return;
        }
        BlockPos pos = mc.f_91074_.m_20183_();
        if (ModConfig.get().compass_hide_when_similar_mods_present && ModCompat.MAP_ATLASES && MapAtlasesCompat.showingCoords((Player)mc.f_91074_)) {
            return;
        }
        String x = String.format("%d", pos.m_123341_());
        String y = String.format("%d", pos.m_123342_());
        String z = String.format("%d", pos.m_123343_());
        int width = Integer.max(x.length(), z.length());
        width = Integer.max(width, y.length());
        x = StringUtils.leftPad((String)x, (int)width);
        y = StringUtils.leftPad((String)y, (int)width);
        z = StringUtils.leftPad((String)z, (int)width);
        int xOffset = 3;
        int yPlacement = ModConfig.get().compass_vertical_position;
        int fontWidth = mc.f_91062_.m_92895_(StringUtils.repeat((String)"a", (int)(width + 2)));
        if (showXZ) {
            coords.add("\u00a7%sX:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_x_colour)), x));
            if (showY) {
                coords.add("\u00a7%sY:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_y_colour)), y));
            }
            coords.add("\u00a7%sZ:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_z_colour)), z));
        } else if (showY) {
            coords.add("\u00a7%sY:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_y_colour)), y));
        }
        if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable) {
            yPlacement -= 15;
        }
        if (ClockOverlay.showWeather) {
            yPlacement += 9;
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.f_91074_)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
        }
        int textureOffset = 7;
        int tooltipSize = 16;
        if (showXZ & showY) {
            textureOffset = 51;
            tooltipSize = 35;
        } else if (showXZ) {
            textureOffset = 25;
            tooltipSize = 25;
        }
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayHelpers.TEXTURE);
        OverlayHelpers.renderBackground(poseStack, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, textureOffset, tooltipSize);
        for (String text : coords) {
            GuiComponent.m_93236_((PoseStack)poseStack, (Font)mc.f_91062_, (String)text, (int)(xPlacement - xOffset), (int)yPlacement, (int)0xE0E0E0);
            Objects.requireNonNull(mc.f_91062_);
            yPlacement += 9;
        }
    }
}

