/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.helpers.ModTags;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final ResourceLocation TEXTURE = ModClient.locate("textures/gui/overlay.png");

    public static void renderBackground(PoseStack poseStack, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int textureOffset, int tooltipSize) {
        if (ModConfig.get().render_background) {
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(xPlacement - xOffset - 4), (int)yPlacementWithOffset, (int)0, (float)0.0f, (float)textureOffset, (int)(fontWidth + xOffset + 4), (int)tooltipSize, (int)256, (int)256);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth), (int)yPlacementWithOffset, (int)0, (float)197.0f, (float)textureOffset, (int)3, (int)tooltipSize, (int)256, (int)256);
        }
    }

    public static void checkInventoryForOverlays(Minecraft minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable) && minecraft.f_91073_ != null) {
            OverlayHelpers.checkInventoryForItems((Player)minecraft.f_91074_);
        }
    }

    public static boolean playerHasPotions(Player player) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        return !player.m_21220_().isEmpty();
    }

    public static int moveBy(Player player) {
        boolean hasBeneficial = player.m_21220_().stream().anyMatch(p -> p.m_19544_().m_19486_());
        boolean hasNegative = player.m_21220_().stream().anyMatch(p -> !p.m_19544_().m_19486_());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean debug(Minecraft mc) {
        boolean debug = mc.f_91066_.f_92063_;
        return debug && (Boolean)mc.f_91066_.m_231824_().m_231551_() == false;
    }

    private static void findImportantContainerContents(ItemStack container) {
        List<ItemStack> list = OverlayHelpers.getContainerContents(container).toList();
        for (ItemStack itemStack : list) {
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (ModLists.compass_items.contains(item)) {
            CompassOverlay.showXZ = true;
        }
        if (ModLists.compass_depth_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
    }

    public static void checkInventoryForItems(Player player) {
        CompassOverlay.showXZ = false;
        CompassOverlay.showY = false;
        ClockOverlay.showTime = false;
        ClockOverlay.showWeather = false;
        if (player == null) {
            return;
        }
        if (ModConfig.get().compass_enable || ModConfig.get().clock_enable) {
            OverlayHelpers.isImportantItemOrContainer(player.m_21206_());
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItemOrContainer(player.m_21205_());
            } else {
                player.m_6168_().forEach(OverlayHelpers::isImportantItemOrContainer);
                OverlayHelpers.checkInventoryForStack(player.m_150109_());
            }
        }
    }

    public static void isImportantItemOrContainer(ItemStack stack) {
        OverlayHelpers.isImportantItem(stack);
        if (OverlayHelpers.isContainer(stack)) {
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static Stream<ItemStack> getContainerContents(ItemStack stack) {
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        if (compoundtag.m_128441_("Items")) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        if (compoundtag.m_128441_("BlockEntityTag")) {
            CompoundTag compound = compoundtag.m_128469_("BlockEntityTag");
            ListTag listtag = compound.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        return Stream.empty();
    }

    public static boolean isContainer(ItemStack stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(ModTags.CONTAINERS)) {
            return true;
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return false;
        }
        if (compoundtag.m_128441_("Items")) {
            return true;
        }
        if (compoundtag.m_128441_("BlockEntityTag") && compoundtag.m_128469_("BlockEntityTag").m_128441_("Items")) {
            return true;
        }
        return true;
    }

    public static boolean checkInventoryForItem(Inventory inventory, Item item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != ItemStack.f_41583_;
    }

    public static void checkInventoryForStack(Inventory inventory) {
        for (ItemStack stack : inventory.f_35974_) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static ItemStack checkInventoryForStack(Inventory inventory, Item item) {
        for (ItemStack stack : inventory.f_35974_) {
            if (stack.m_150930_(item)) {
                return stack;
            }
            if (item != null && stack.m_150930_(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<ItemStack> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (ItemStack content : contents) {
                if (item == null || !content.m_150930_(item)) continue;
                return content;
            }
        }
        return ItemStack.f_41583_;
    }

    public static int getPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }
}

