/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import me.khajiitos.worldplaytime.common.WorldPlayTime;
import me.khajiitos.worldplaytime.common.config.WPTConfigValues;
import me.khajiitos.worldplaytime.common.util.Color;
import me.khajiitos.worldplaytime.common.util.ServerEntryRenderPos;
import me.khajiitos.worldplaytime.common.util.WorldEntryRenderPos;

public class WPTConfig {
    private static final File file = new File("config/worldplaytime/config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Entry
    public static final WPTConfigValues.BooleanValue showServerPlayTime = new WPTConfigValues.BooleanValue(false);
    @Entry
    public static final WPTConfigValues.EnumValue<ServerEntryRenderPos> serverPlayTimePosition = new WPTConfigValues.EnumValue<ServerEntryRenderPos>(ServerEntryRenderPos.AFTER_NAME);
    @Entry
    public static final WPTConfigValues.ColorValue serverPlayTimeColor = new WPTConfigValues.ColorValue(new Color(128, 128, 128, 255));
    @Entry
    public static final WPTConfigValues.BooleanValue showWorldPlayTime = new WPTConfigValues.BooleanValue(true);
    @Entry
    public static final WPTConfigValues.EnumValue<WorldEntryRenderPos> worldPlayTimePosition = new WPTConfigValues.EnumValue<WorldEntryRenderPos>(WorldEntryRenderPos.TOP_RIGHT);
    @Entry
    public static final WPTConfigValues.ColorValue worldPlayTimeColor = new WPTConfigValues.ColorValue(new Color(128, 128, 128, 255));

    public static void init() {
        if (!file.exists()) {
            WPTConfig.save();
        } else {
            WPTConfig.load();
        }
    }

    public static void save() {
        if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            WorldPlayTime.LOGGER.error("Failed to create config/worldplaytime/ directory");
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            JsonObject jsonObject = new JsonObject();
            for (Field field : WPTConfig.class.getDeclaredFields()) {
                Object object;
                if (!field.isAnnotationPresent(Entry.class) || !((object = field.get(null)) instanceof WPTConfigValues.Value)) continue;
                WPTConfigValues.Value configValue = (WPTConfigValues.Value)object;
                jsonObject.add(field.getName(), configValue.write());
            }
            GSON.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (IOException e) {
            WorldPlayTime.LOGGER.error("Failed to save the World Play Time config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            WorldPlayTime.LOGGER.error("Error while saving the World Play Time config", (Throwable)e);
        }
    }

    public static void load() {
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
            for (Field field : WPTConfig.class.getDeclaredFields()) {
                Object object;
                String fieldName;
                if (!field.isAnnotationPresent(Entry.class) || !jsonObject.has(fieldName = field.getName()) || !((object = field.get(null)) instanceof WPTConfigValues.Value)) continue;
                WPTConfigValues.Value configValue = (WPTConfigValues.Value)object;
                JsonElement jsonElement = jsonObject.get(fieldName);
                configValue.setUnchecked(configValue.read(jsonElement));
            }
        }
        catch (IOException e) {
            WorldPlayTime.LOGGER.error("Failed to read the World Play Time config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            WorldPlayTime.LOGGER.error("Error while reading the World Play Time config", (Throwable)e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Entry {
    }
}

