/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import me.khajiitos.worldplaytime.common.config.ServerPlayTimeManager;
import me.khajiitos.worldplaytime.common.config.WPTConfig;
import me.khajiitos.worldplaytime.common.util.Color;
import me.khajiitos.worldplaytime.common.util.PlayTimeRenderer;
import me.khajiitos.worldplaytime.common.util.ServerEntryRenderPos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.FormattedText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSelectionList.OnlineServerEntry.class}, priority=2000)
public class OnlineServerEntryMixin {
    @Shadow
    @Final
    private ServerData f_99857_;
    @Shadow
    @Final
    private Minecraft f_99856_;
    @Unique
    private static float worldplaytime$serverNameStartX;

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;draw(Lcom/mojang/blaze3d/vertex/PoseStack;Ljava/lang/String;FFI)I", ordinal=0), method={"render"}, index=2)
    public float serverNameX(float x) {
        worldplaytime$serverNameStartX = x;
        return x;
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void onRender(PoseStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        int renderY;
        int renderX;
        if (!((Boolean)WPTConfig.showServerPlayTime.get()).booleanValue()) {
            return;
        }
        int playTime = ServerPlayTimeManager.getPlayTime(this.f_99857_.f_105363_);
        int playTimeWidth = PlayTimeRenderer.getWholeWidth(playTime);
        if (playTimeWidth <= 0) {
            return;
        }
        ServerEntryRenderPos renderPos = (ServerEntryRenderPos)((Object)WPTConfig.serverPlayTimePosition.get());
        switch (renderPos) {
            case AFTER_NAME: {
                int serverNameWidth = this.f_99856_.f_91062_.m_92895_(this.f_99857_.f_105362_);
                renderX = (int)(worldplaytime$serverNameStartX + 3.0f + (float)serverNameWidth);
                renderY = y + 1;
                break;
            }
            case BEHIND_COUNT: {
                int statusWidth = this.f_99856_.f_91062_.m_92852_((FormattedText)this.f_99857_.f_105364_);
                renderX = x + entryWidth - 52 - statusWidth;
                renderY = y;
                break;
            }
            case LEFT: {
                renderX = x - playTimeWidth - 5;
                renderY = y + 10;
                break;
            }
            case RIGHT: {
                renderX = x + entryWidth + 6;
                renderY = y + 10;
                break;
            }
            default: {
                return;
            }
        }
        PlayTimeRenderer.render(poseStack, renderX, renderY, playTime, (Color)WPTConfig.serverPlayTimeColor.get());
    }
}

