/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.khajiitos.worldplaytime.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PlayTimeRenderer {
    private static final ResourceLocation TIME_ICON = new ResourceLocation("worldplaytime", "textures/gui/time_icon.png");

    @Nullable
    public static Component getPlayTimeComponent(int ticks) {
        if (ticks <= 0) {
            return null;
        }
        double hours = (double)ticks / 20.0 / 3600.0;
        return Component.m_237110_((String)"worldplaytime.format", (Object[])new Object[]{Component.m_237113_((String)(hours >= 100.0 ? String.valueOf((int)hours) : String.format("%.1f", hours)))});
    }

    public static int getWholeWidth(int ticks) {
        Component component = PlayTimeRenderer.getPlayTimeComponent(ticks);
        if (component == null) {
            return 0;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91062_.m_92852_((FormattedText)component) + 11;
    }

    public static void render(PoseStack poseStack, int x, int y, int playTimeTicks, Color color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Component component = PlayTimeRenderer.getPlayTimeComponent(playTimeTicks);
        if (component == null) {
            return;
        }
        RenderSystem.m_157429_((float)((float)color.r / 255.0f), (float)((float)color.g / 255.0f), (float)((float)color.b / 255.0f), (float)((float)color.a / 255.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)TIME_ICON);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.f_91062_.m_92889_(poseStack, component, (float)(x + 11), (float)(y + 1), color.toARGB());
    }
}

