/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonefortress.world.processors;

import com.izofar.bygonefortress.init.ModProcessors;
import com.izofar.bygonefortress.util.ModStructureUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DataBlockProcessor
extends StructureProcessor {
    private static final ResourceLocation EMPTY_RL = new ResourceLocation("minecraft", "empty");
    public static final Codec<DataBlockProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122883_).forGetter(processor -> processor.processorListRegistry), (App)Codec.mapPair((MapCodec)BlockState.f_61039_.fieldOf("trigger"), (MapCodec)BlockState.f_61039_.fieldOf("replacement")).codec().listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockState)entry.getKey()), (Object)((BlockState)entry.getValue()))).collect(Collectors.toList())).fieldOf("trigger_and_replacements").forGetter(processor -> processor.triggerAndReplacementBlocks), (App)ResourceLocation.f_135803_.optionalFieldOf("processor_list", (Object)EMPTY_RL).forGetter(processor -> processor.processorList), (App)Direction.f_175356_.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)Codec.INT.optionalFieldOf("length", (Object)1000).forGetter(config -> config.length), (App)Codec.BOOL.optionalFieldOf("forced_placement", (Object)false).forGetter(config -> config.forcePlacement)).apply((Applicative)instance, instance.stable(DataBlockProcessor::new)));
    public final Registry<StructureProcessorList> processorListRegistry;
    public final Map<BlockState, BlockState> triggerAndReplacementBlocks;
    public final ResourceLocation processorList;
    public final Direction direction;
    public final int length;
    public final boolean forcePlacement;

    private DataBlockProcessor(Registry<StructureProcessorList> processorListRegistry, Map<BlockState, BlockState> triggerAndReplacementBlocks, ResourceLocation processorList, Direction direction, int length, boolean forcePlacement) {
        this.processorListRegistry = processorListRegistry;
        this.triggerAndReplacementBlocks = triggerAndReplacementBlocks;
        this.processorList = processorList;
        this.direction = direction;
        this.length = length;
        this.forcePlacement = forcePlacement;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos templateOffset, BlockPos worldOffset, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        if (this.triggerAndReplacementBlocks.containsKey(blockState)) {
            WorldGenRegion worldGenRegion;
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            BlockState replacementState = this.triggerAndReplacementBlocks.get(blockState);
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)worldPos);
            StructureProcessorList structureProcessorList = null;
            if (this.processorList != null && !this.processorList.equals((Object)EMPTY_RL)) {
                structureProcessorList = (StructureProcessorList)this.processorListRegistry.m_7745_(this.processorList);
            }
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return replacementState == null || replacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
            }
            int terrainY = Integer.MIN_VALUE;
            if (this.direction == Direction.DOWN && !this.forcePlacement && (terrainY = ModStructureUtils.getFirstLandYFromPos(levelReader, worldPos)) <= levelReader.m_141937_() && this.length + 2 >= worldPos.m_123342_() - levelReader.m_141937_()) {
                return replacementState == null || replacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
            }
            BlockState currentBlock = levelReader.m_8055_(worldPos.m_7495_());
            while (!(!this.forcePlacement && currentBlock.m_60815_() || !this.forcePlacement && currentPos.m_123342_() < terrainY || levelReader.m_151562_(currentPos.m_123342_()) || !currentPos.m_123314_((Vec3i)worldPos, (double)this.length))) {
                StructureTemplate.StructureBlockInfo newPillarState1 = new StructureTemplate.StructureBlockInfo(currentPos.m_121996_((Vec3i)worldPos).m_121955_((Vec3i)templateOffset), replacementState, null);
                StructureTemplate.StructureBlockInfo newPillarState2 = new StructureTemplate.StructureBlockInfo(currentPos.m_7949_(), replacementState, null);
                if (structureProcessorList != null) {
                    for (StructureProcessor processor : structureProcessorList.m_74425_()) {
                        if (newPillarState2 == null) break;
                        newPillarState2 = processor.m_7382_(levelReader, newPillarState1.f_74675_, newPillarState2.f_74675_, newPillarState1, newPillarState2, structurePlacementData);
                    }
                }
                if (newPillarState2 != null) {
                    levelReader.m_46865_((BlockPos)currentPos).m_6978_((BlockPos)currentPos, newPillarState2.f_74676_, false);
                }
                currentPos.m_122173_(this.direction);
                currentBlock = levelReader.m_8055_((BlockPos)currentPos);
            }
            return replacementState == null || replacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ModProcessors.DATA_BLOCK_PROCESSOR.get();
    }
}

