/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes;

import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.data.ModItemContainerProvider;
import fuzs.easyshulkerboxes.data.ModLanguageProvider;
import fuzs.easyshulkerboxes.impl.capability.ContainerClientInputCapability;
import fuzs.easyshulkerboxes.impl.capability.EnderChestMenuCapability;
import fuzs.easyshulkerboxes.impl.handler.EnderChestMenuHandler;
import fuzs.easyshulkerboxes.impl.init.ModRegistry;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CommonFactories;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="easyshulkerboxes")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EasyShulkerBoxesForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CommonFactories.INSTANCE.modConstructor("easyshulkerboxes").accept(new EasyShulkerBoxes());
        EasyShulkerBoxesForge.registerCapabilities();
        EasyShulkerBoxesForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.ENDER_CHEST_MENU_CAPABILITY, (CapabilityToken)new CapabilityToken<EnderChestMenuCapability>(){});
        ForgeCapabilityController.setCapabilityToken(ModRegistry.CONTAINER_SLOT_CAPABILITY, (CapabilityToken)new CapabilityToken<ContainerClientInputCapability>(){});
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> EnderChestMenuHandler.onLivingTick(evt.getEntity()));
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.addListener((PreparableReloadListener)ItemContainerProviders.INSTANCE));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            ServerPlayer player = evt.getPlayer();
            if (player != null) {
                ItemContainerProviders.INSTANCE.sendProvidersToPlayer(player);
            } else {
                for (ServerPlayer serverPlayer : evt.getPlayerList().m_11314_()) {
                    ItemContainerProviders.INSTANCE.sendProvidersToPlayer(serverPlayer);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModItemContainerProvider(generator));
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "easyshulkerboxes"));
    }
}

