/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.container.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityViewProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BundleProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.EnderChestProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.NestedTagItemProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.SimpleItemProvider;
import fuzs.easyshulkerboxes.impl.client.helper.GsonEnumHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class ItemContainerProviderBuilder {
    private int inventoryWidth;
    private int inventoryHeight;
    @Nullable
    private DyeColor dyeColor;
    private String[] nbtKey;
    private boolean filterContainerItems;
    private BlockEntityType<?> blockEntityType;
    private int capacity;
    private List<String> disallowedItems;
    private boolean anyGameMode;
    @Nullable
    private EquipmentSlot equipmentSlot;

    private ItemContainerProviderBuilder() {
    }

    public static Function<JsonElement, ItemContainerProvider> fromJson(Function<ItemContainerProviderBuilder, ItemContainerProvider> factory) {
        return jsonElement -> {
            ItemContainerProviderBuilder builder = new ItemContainerProviderBuilder();
            builder.fromJson((JsonElement)jsonElement);
            ItemContainerProvider provider = (ItemContainerProvider)factory.apply(builder);
            if (provider instanceof SimpleItemProvider) {
                SimpleItemProvider itemProvider = (SimpleItemProvider)provider;
                if (builder.filterContainerItems) {
                    itemProvider.filterContainerItems();
                }
            }
            if (provider instanceof NestedTagItemProvider) {
                NestedTagItemProvider nestedTagProvider = (NestedTagItemProvider)provider;
                nestedTagProvider.disallowValues(builder.disallowedItems);
            }
            return provider;
        };
    }

    private void fromJson(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.inventoryWidth = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"inventory_width", (int)-1);
        this.inventoryHeight = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"inventory_height", (int)-1);
        this.dyeColor = DyeColor.m_41057_((String)GsonHelper.m_13851_((JsonObject)jsonObject, (String)"background_color", (String)""), null);
        this.nbtKey = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"nbt_key", (String)"Items").split("/");
        this.filterContainerItems = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"filter_container_items", (boolean)false);
        if (jsonObject.has("block_entity_type")) {
            ResourceLocation blockEntityTypeKey = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block_entity_type"));
            this.blockEntityType = (BlockEntityType)Registry.f_122830_.m_7745_(blockEntityTypeKey);
        }
        this.capacity = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"capacity", (int)-1);
        JsonArray disallowedItemsData = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"disallowed_items", (JsonArray)new JsonArray());
        this.disallowedItems = StreamSupport.stream(disallowedItemsData.spliterator(), false).map(JsonElement::getAsString).toList();
        this.anyGameMode = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"any_game_mode", (boolean)false);
        this.equipmentSlot = GsonEnumHelper.getAsEnum(jsonObject, "equipment_slot", EquipmentSlot.class, null);
    }

    public ItemContainerProvider toSimpleItemContainerProvider() {
        this.checkInventorySize("item");
        return new SimpleItemProvider(this.inventoryWidth, this.inventoryHeight, this.dyeColor, this.nbtKey).equipmentSlot(this.equipmentSlot);
    }

    public ItemContainerProvider toBlockEntityProvider() {
        this.checkInventorySize("block_entity");
        Objects.requireNonNull(this.blockEntityType, ItemContainerProviderBuilder.getErrorMessage("block_entity_type", "block_entity"));
        BlockEntityProvider provider = new BlockEntityProvider(this.blockEntityType, this.inventoryWidth, this.inventoryHeight, this.dyeColor, this.nbtKey);
        if (this.anyGameMode) {
            provider.anyGameMode();
        }
        return provider.equipmentSlot(this.equipmentSlot);
    }

    public ItemContainerProvider toBlockEntityViewProvider() {
        this.checkInventorySize("block_entity_view");
        Objects.requireNonNull(this.blockEntityType, ItemContainerProviderBuilder.getErrorMessage("block_entity_type", "block_entity_view"));
        return new BlockEntityViewProvider(this.blockEntityType, this.inventoryWidth, this.inventoryHeight, this.dyeColor, this.nbtKey).equipmentSlot(this.equipmentSlot);
    }

    public ItemContainerProvider toBundleProvider() {
        if (this.capacity == -1) {
            throw new IllegalStateException(ItemContainerProviderBuilder.getErrorMessage("capacity", "bundle"));
        }
        return new BundleProvider(this.capacity, this.dyeColor, this.nbtKey);
    }

    public ItemContainerProvider toEnderChestProvider() {
        return new EnderChestProvider();
    }

    private void checkInventorySize(String type) {
        if (this.inventoryWidth == -1) {
            throw new IllegalStateException(ItemContainerProviderBuilder.getErrorMessage("inventory_width", type));
        }
        if (this.inventoryHeight == -1) {
            throw new IllegalStateException(ItemContainerProviderBuilder.getErrorMessage("inventory_height", type));
        }
    }

    private static String getErrorMessage(String jsonKey, String providerType) {
        return "'%s' not set for provider of type '%s'".formatted(jsonKey, providerType);
    }
}

