/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.container.v1;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.container.v1.ItemContainerProviderBuilder;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityViewProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BundleProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.SimpleItemProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ItemContainerProviderSerializers {
    private static final Map<ResourceLocation, Serializer> SERIALIZERS_BY_ID = Collections.synchronizedMap(Maps.newHashMap());
    private static final Map<Class<? extends ItemContainerProvider>, Serializer> SERIALIZERS_BY_TYPE = Collections.synchronizedMap(Maps.newHashMap());

    public static void register(Class<? extends ItemContainerProvider> clazz, ResourceLocation id, Function<JsonElement, ItemContainerProvider> deserializer) {
        Serializer serializer = new Serializer(clazz, id, deserializer);
        SERIALIZERS_BY_ID.put(id, serializer);
        SERIALIZERS_BY_TYPE.put(clazz, serializer);
    }

    public static JsonElement serialize(ItemContainerProvider provider) {
        Serializer serializer = SERIALIZERS_BY_TYPE.get(provider.getClass());
        Objects.requireNonNull(serializer, "no serializer registered for class %s".formatted(provider.getClass()));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", serializer.id().toString());
        provider.toJson(jsonObject);
        return jsonObject;
    }

    public static ItemContainerProvider deserialize(JsonObject jsonObject) {
        ResourceLocation identifier = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type"));
        Serializer serializer = SERIALIZERS_BY_ID.get(identifier);
        Objects.requireNonNull(serializer, "no serializer registered for identifier %s".formatted(identifier));
        return serializer.deserializer().apply((JsonElement)jsonObject);
    }

    static {
        ItemContainerProviderSerializers.register(BlockEntityProvider.class, EasyShulkerBoxes.id("block_entity"), ItemContainerProviderBuilder.fromJson(ItemContainerProviderBuilder::toBlockEntityProvider));
        ItemContainerProviderSerializers.register(BlockEntityViewProvider.class, EasyShulkerBoxes.id("block_entity_view"), ItemContainerProviderBuilder.fromJson(ItemContainerProviderBuilder::toBlockEntityViewProvider));
        ItemContainerProviderSerializers.register(BundleProvider.class, EasyShulkerBoxes.id("bundle"), ItemContainerProviderBuilder.fromJson(ItemContainerProviderBuilder::toBundleProvider));
        ItemContainerProviderSerializers.register(SimpleItemProvider.class, EasyShulkerBoxes.id("item"), ItemContainerProviderBuilder.fromJson(ItemContainerProviderBuilder::toSimpleItemContainerProvider));
    }

    private record Serializer(Class<? extends ItemContainerProvider> clazz, ResourceLocation id, Function<JsonElement, ItemContainerProvider> deserializer) {
    }
}

