/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.container.v1.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import fuzs.easyshulkerboxes.api.container.v1.ItemContainerProviderSerializers;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractItemContainerProvider
implements DataProvider {
    private final Map<ResourceLocation, ItemContainerProvider> providers = Maps.newHashMap();
    private final DataGenerator dataGenerator;

    public AbstractItemContainerProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public final void m_213708_(CachedOutput output) throws IOException {
        this.registerBuiltInProviders();
        Path outputFolder = this.dataGenerator.m_123916_();
        for (Map.Entry<ResourceLocation, ItemContainerProvider> entry : this.providers.entrySet()) {
            JsonElement jsonElement = ItemContainerProviderSerializers.serialize(entry.getValue());
            ResourceLocation item = entry.getKey();
            Path path = outputFolder.resolve(PackType.SERVER_DATA.m_10305_()).resolve(item.m_135827_()).resolve("item_container_providers").resolve(item.m_135815_() + ".json");
            DataProvider.m_236072_((CachedOutput)output, (JsonElement)jsonElement, (Path)path);
        }
    }

    protected abstract void registerBuiltInProviders();

    public void add(ItemLike item, ItemContainerProvider provider) {
        this.add(Registry.f_122827_.m_7981_((Object)item.m_5456_()), provider);
    }

    public void add(ResourceLocation item, ItemContainerProvider provider) {
        this.providers.put(item, provider);
    }

    public String m_6055_() {
        return "Item Container Provider";
    }
}

