/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.data;

import fuzs.easyshulkerboxes.api.container.v1.data.AbstractItemContainerProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BlockEntityViewProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.BundleProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.EnderChestProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.integration.bagofholding.BagOfHoldingIntegration;
import fuzs.easyshulkerboxes.integration.inmis.InmisIntegration;
import fuzs.easyshulkerboxes.integration.reinforcedshulkerboxes.ReinforcedShulkerBoxesIntegration;
import fuzs.easyshulkerboxes.integration.simplebackpack.SimpleBackpackIntegration;
import fuzs.easyshulkerboxes.world.item.container.MapProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModItemContainerProvider
extends AbstractItemContainerProvider {
    public ModItemContainerProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    protected void registerBuiltInProviders() {
        this.registerVanillaProviders();
        BagOfHoldingIntegration.registerProviders(this::add);
        SimpleBackpackIntegration.registerProviders(this::add);
        InmisIntegration.registerProviders(this::add);
        ReinforcedShulkerBoxesIntegration.registerProviders(this::add);
    }

    private void registerVanillaProviders() {
        this.registerShulkerBoxProviders();
        this.add((ItemLike)Items.f_42108_, (ItemContainerProvider)new EnderChestProvider());
        this.add((ItemLike)Items.f_151058_, (ItemContainerProvider)new BundleProvider(64));
        this.add((ItemLike)Items.f_42573_, (ItemContainerProvider)new MapProvider());
        this.add((ItemLike)Items.f_42162_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58923_, 3, 3));
        this.add((ItemLike)Items.f_41855_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58922_, 3, 3));
        this.add((ItemLike)Items.f_42009_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58918_, 9, 3));
        this.add((ItemLike)Items.f_42149_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58919_, 9, 3));
        this.add((ItemLike)Items.f_42768_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58942_, 9, 3));
        this.add((ItemLike)Items.f_42155_, (ItemContainerProvider)new BlockEntityProvider(BlockEntityType.f_58933_, 5, 1));
        this.add((ItemLike)Items.f_41962_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58917_, 3, 1));
        this.add((ItemLike)Items.f_42770_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58907_, 3, 1));
        this.add((ItemLike)Items.f_42769_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58906_, 3, 1));
        this.add((ItemLike)Items.f_42543_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58927_, 5, 1));
        this.add((ItemLike)Items.f_42781_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58911_, 4, 1));
        this.add((ItemLike)Items.f_42782_, (ItemContainerProvider)new BlockEntityViewProvider(BlockEntityType.f_58911_, 4, 1));
    }

    private void registerShulkerBoxProviders() {
        this.add((ItemLike)Items.f_42265_, BlockEntityProvider.shulkerBoxProvider(BlockEntityType.f_58939_, 9, 3, null));
        for (DyeColor dyeColor : DyeColor.values()) {
            Item item = ShulkerBoxBlock.m_56190_((DyeColor)dyeColor).m_5456_();
            this.add((ItemLike)item, BlockEntityProvider.shulkerBoxProvider(BlockEntityType.f_58939_, 9, 3, dyeColor));
        }
    }
}

