/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.impl.config.ClientConfig;
import fuzs.easyshulkerboxes.impl.config.ServerConfig;
import fuzs.easyshulkerboxes.impl.network.client.C2SContainerClientInputMessage;
import fuzs.easyshulkerboxes.impl.world.inventory.ContainerSlotHelper;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.easyshulkerboxes.mixin.client.accessor.AbstractContainerScreenAccessor;
import fuzs.easyshulkerboxes.mixin.client.accessor.ScreenAccessor;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import fuzs.puzzleslib.network.Message;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientInputActionHandler {
    private static int lastSentContainerSlot = -1;
    private static boolean lastSentExtractSingleItem;

    public static Optional<Unit> onBeforeKeyPressed(Screen screen, int keyCode, int scanCode, int modifiers) {
        if (!(screen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
        ClientInputActionHandler.ensureHasSentContainerClientInput(screen, (Player)minecraft.f_91074_);
        return Optional.empty();
    }

    public static Optional<Unit> onBeforeMousePressed(Screen screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
        ClientInputActionHandler.ensureHasSentContainerClientInput(screen, (Player)minecraft.f_91074_);
        return Optional.empty();
    }

    public static Optional<Unit> onBeforeMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (ClientInputActionHandler.precisionModeAllowedAndActive() && !ClientInputActionHandler.getContainerStack(containerScreen, false).m_41619_()) {
            ((AbstractContainerScreenAccessor)screen).easyshulkerboxes$setDoubleclick(false);
        }
        return Optional.empty();
    }

    public static void onAfterRender(Screen screen, PoseStack matrices, int mouseX, int mouseY, float tickDelta) {
        ItemStack stack;
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).carriedItemTooltips.isActive()) {
            return;
        }
        if (!containerScreen.m_6262_().m_142621_().m_41619_() && !(stack = ClientInputActionHandler.getContainerStack(containerScreen, false)).m_41619_()) {
            ((ScreenAccessor)screen).easyshulkerboxes$callRenderTooltip(matrices, stack, mouseX, mouseY);
        }
    }

    private static boolean renderProviderItemTooltip(Screen screen, PoseStack matrices, int mouseX, int mouseY, ItemStack stack) {
        if (ItemContainerProviders.INSTANCE.get(stack) != null) {
            ((ScreenAccessor)screen).easyshulkerboxes$callRenderTooltip(matrices, stack, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public static Optional<Unit> onBeforeMouseScroll(Screen screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount == 0.0 || !(screen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).revealContents.isActive()) {
            return Optional.empty();
        }
        Slot slot = CommonScreens.INSTANCE.getHoveredSlot(containerScreen);
        if (ClientInputActionHandler.precisionModeAllowedAndActive()) {
            if (slot != null && (ItemContainerProviders.INSTANCE.get(containerScreen.m_6262_().m_142621_()) != null || ItemContainerProviders.INSTANCE.get(slot.m_7993_()) != null)) {
                int mouseButton = (((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).invertPrecisionModeScrolling ? verticalAmount < 0.0 : verticalAmount > 0.0) ? 1 : 0;
                ((AbstractContainerScreenAccessor)screen).easyshulkerboxes$callSlotClicked(slot, slot.f_40219_, mouseButton, ClickType.PICKUP);
                return Optional.of(Unit.INSTANCE);
            }
        } else if (((ServerConfig)EasyShulkerBoxes.CONFIG.get(ServerConfig.class)).allowSlotCycling) {
            ItemStack carriedStack = containerScreen.m_6262_().m_142621_();
            if (!carriedStack.m_41619_() && !((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).carriedItemTooltips.isActive()) {
                return Optional.empty();
            }
            ItemStack stack = ClientInputActionHandler.getContainerStack(containerScreen, true);
            if (!stack.m_41619_()) {
                Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
                int currentContainerSlot = ContainerSlotHelper.getCurrentContainerSlot((Player)minecraft.f_91074_);
                ItemContainerProvider provider = ItemContainerProviders.INSTANCE.get(stack);
                Objects.requireNonNull(provider, "provider is null");
                SimpleContainer container = provider.getItemContainer(stack, (Player)minecraft.f_91074_, false);
                currentContainerSlot = ContainerSlotHelper.findClosestSlotWithContent(container, currentContainerSlot, verticalAmount < 0.0);
                ContainerSlotHelper.setCurrentContainerSlot((Player)minecraft.f_91074_, currentContainerSlot);
                return Optional.of(Unit.INSTANCE);
            }
        }
        return Optional.empty();
    }

    public static ItemStack getContainerStack(AbstractContainerScreen<?> screen, boolean requireItemContainerData) {
        ItemStack stack = screen.m_6262_().m_142621_();
        ItemContainerProvider provider = ItemContainerProviders.INSTANCE.get(stack);
        if (provider != null && (!requireItemContainerData || provider.hasItemContainerData(stack))) {
            return stack;
        }
        Slot slot = CommonScreens.INSTANCE.getHoveredSlot(screen);
        if (slot != null && (provider = ItemContainerProviders.INSTANCE.get(stack = slot.m_7993_())) != null && (!requireItemContainerData || provider.hasItemContainerData(stack))) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static Optional<Unit> onPlaySoundAtPosition(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).disableInteractionSounds) {
            return Optional.empty();
        }
        if (source == SoundSource.PLAYERS && (sound == SoundEvents.f_184215_ || sound == SoundEvents.f_184216_)) {
            return Optional.of(Unit.INSTANCE);
        }
        return Optional.empty();
    }

    public static boolean precisionModeAllowedAndActive() {
        return ((ServerConfig)EasyShulkerBoxes.CONFIG.get(ServerConfig.class)).allowPrecisionMode && ((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).precisionMode.isActive();
    }

    public static void ensureHasSentContainerClientInput(Screen screen, Player player) {
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        int currentContainerSlot = ContainerSlotHelper.getCurrentContainerSlot(player);
        boolean extractSingleItem = ClientInputActionHandler.precisionModeAllowedAndActive();
        if (currentContainerSlot != lastSentContainerSlot || extractSingleItem != lastSentExtractSingleItem) {
            lastSentContainerSlot = currentContainerSlot;
            lastSentExtractSingleItem = extractSingleItem;
            ContainerSlotHelper.extractSingleItem(player, extractSingleItem);
            EasyShulkerBoxes.NETWORK.sendToServer((Message)new C2SContainerClientInputMessage(currentContainerSlot, extractSingleItem));
        }
    }
}

