/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.client.handler;

import com.google.common.collect.Sets;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.impl.client.handler.ClientInputActionHandler;
import fuzs.easyshulkerboxes.impl.config.ClientConfig;
import fuzs.easyshulkerboxes.impl.config.ServerConfig;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.easyshulkerboxes.mixin.client.accessor.AbstractContainerScreenAccessor;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MouseDraggingHandler {
    public static final MouseDraggingHandler INSTANCE = new MouseDraggingHandler();
    public final Set<Slot> containerDragSlots = Sets.newHashSet();
    @Nullable
    private ContainerDragType containerDragType;

    public Optional<Unit> onBeforeMousePressed(Screen screen, double mouseX, double mouseY, int button) {
        Slot slot;
        if (!MouseDraggingHandler.shouldHandleMouseDragging(screen)) {
            return Optional.empty();
        }
        ItemStack carriedStack = ((AbstractContainerScreen)screen).m_6262_().m_142621_();
        ItemContainerProvider provider = ItemContainerProviders.INSTANCE.get(carriedStack);
        Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
        if (MouseDraggingHandler.validMouseButton(button) && provider != null && provider.allowsPlayerInteractions(carriedStack, (Player)minecraft.f_91074_) && (slot = ((AbstractContainerScreenAccessor)screen).easyshulkerboxes$callFindSlot(mouseX, mouseY)) != null) {
            this.containerDragType = slot.m_6657_() && !ClientInputActionHandler.precisionModeAllowedAndActive() ? ContainerDragType.INSERT : ContainerDragType.REMOVE;
            this.containerDragSlots.clear();
            return Optional.of(Unit.INSTANCE);
        }
        this.containerDragType = null;
        return Optional.empty();
    }

    public Optional<Unit> onBeforeMouseDragged(Screen screen, double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!MouseDraggingHandler.shouldHandleMouseDragging(screen)) {
            return Optional.empty();
        }
        if (this.containerDragType != null) {
            if (!MouseDraggingHandler.validMouseButton(button)) {
                this.containerDragType = null;
                this.containerDragSlots.clear();
                return Optional.empty();
            }
            Slot slot = ((AbstractContainerScreenAccessor)screen).easyshulkerboxes$callFindSlot(mouseX, mouseY);
            AbstractContainerMenu menu = ((AbstractContainerScreen)screen).m_6262_();
            if (slot != null && menu.m_5622_(slot) && !this.containerDragSlots.contains(slot)) {
                ItemStack carriedStack = menu.m_142621_();
                ItemContainerProvider provider = ItemContainerProviders.INSTANCE.get(carriedStack);
                Objects.requireNonNull(provider, "provider is null");
                Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
                boolean interact = false;
                if (this.containerDragType == ContainerDragType.INSERT && slot.m_6657_() && provider.canAddItem(carriedStack, slot.m_7993_(), (Player)minecraft.f_91074_)) {
                    interact = true;
                } else if (this.containerDragType == ContainerDragType.REMOVE) {
                    boolean normalInteraction;
                    boolean bl = normalInteraction = button == 1 && !slot.m_6657_() && !provider.getItemContainer(carriedStack, (Player)minecraft.f_91074_, false).m_7983_();
                    if (normalInteraction || slot.m_6657_() && ClientInputActionHandler.precisionModeAllowedAndActive()) {
                        interact = true;
                    }
                }
                if (interact) {
                    ((AbstractContainerScreenAccessor)screen).easyshulkerboxes$callSlotClicked(slot, slot.f_40219_, button, ClickType.PICKUP);
                    this.containerDragSlots.add(slot);
                    return Optional.of(Unit.INSTANCE);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<Unit> onBeforeMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (!MouseDraggingHandler.shouldHandleMouseDragging(screen)) {
            return Optional.empty();
        }
        if (this.containerDragType != null) {
            if (MouseDraggingHandler.validMouseButton(button) && !this.containerDragSlots.isEmpty()) {
                if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).disableInteractionSounds) {
                    SimpleSoundInstance sound = SimpleSoundInstance.m_119755_((SoundEvent)this.containerDragType.sound, (float)0.8f, (float)(0.8f + SoundInstance.m_235150_().m_188501_() * 0.4f));
                    CommonScreens.INSTANCE.getMinecraft(screen).m_91106_().m_120367_((SoundInstance)sound);
                }
                this.containerDragType = null;
                this.containerDragSlots.clear();
                return Optional.of(Unit.INSTANCE);
            }
            this.containerDragType = null;
        }
        this.containerDragSlots.clear();
        return Optional.empty();
    }

    private static boolean shouldHandleMouseDragging(Screen screen) {
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        return ((ServerConfig)EasyShulkerBoxes.CONFIG.get(ServerConfig.class)).allowMouseDragging;
    }

    private static boolean validMouseButton(int button) {
        if (button == 0) {
            return ClientInputActionHandler.precisionModeAllowedAndActive();
        }
        return button == 1;
    }

    public Optional<Unit> onPlaySoundAtPosition(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (this.containerDragType != null && source == SoundSource.PLAYERS && sound == this.containerDragType.sound) {
            return Optional.of(Unit.INSTANCE);
        }
        return Optional.empty();
    }

    private static enum ContainerDragType {
        INSERT(SoundEvents.f_184215_),
        REMOVE(SoundEvents.f_184216_);

        public final SoundEvent sound;

        private ContainerDragType(SoundEvent sound) {
            this.sound = sound;
        }
    }
}

