/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.client.helper;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.impl.config.ClientConfig;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.easyshulkerboxes.mixin.client.accessor.AbstractContainerMenuAccessor;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import fuzs.puzzleslib.client.renderer.entity.DynamicItemDecorator;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemDecorationHelper {
    private static final Map<ItemContainerProvider, DynamicItemDecorator> DECORATORS_CACHE = Maps.newIdentityHashMap();
    @Nullable
    private static Slot activeSlot;

    private static DynamicItemDecorator getDynamicItemDecorator(ItemDecoratorProvider filter, BooleanSupplier allow) {
        return (font, stack, itemPosX, itemPosY, blitOffset) -> {
            if (!allow.getAsBoolean()) {
                return false;
            }
            return ItemDecorationHelper.tryRenderItemDecorations(font, stack, itemPosX, itemPosY, blitOffset, filter);
        };
    }

    private static boolean tryRenderItemDecorations(Font font, ItemStack stack, int itemPosX, int itemPosY, float blitOffset, ItemDecoratorProvider filter) {
        ItemDecoratorType type;
        ItemStack carriedStack;
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        AbstractContainerMenu menu = screen2.m_6262_();
        if (activeSlot != null && activeSlot.m_7993_() == stack && activeSlot.m_150651_((Player)minecraft.f_91074_) && !ItemDecorationHelper.isCreativeInventorySlot(menu, activeSlot) && stack != (carriedStack = menu.m_142621_()) && (type = filter.get(screen2, stack, carriedStack)) != ItemDecoratorType.NONE) {
            PoseStack posestack = new PoseStack();
            posestack.m_85837_(0.0, 0.0, (double)blitOffset + 200.0);
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            font.m_92811_(type.getText(), (float)(itemPosX + 19 - 2 - type.getWidth(font)), (float)(itemPosY + 6 + 3), type.getColor(), true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
            multibuffersource$buffersource.m_109911_();
            return true;
        }
        return false;
    }

    private static boolean isCreativeInventorySlot(AbstractContainerMenu menu, Slot slot) {
        if (((AbstractContainerMenuAccessor)menu).easyshulkerboxes$getMenuType() == null && slot.getClass() != Slot.class && slot.f_40218_ != null) {
            return slot.f_40218_.m_6643_() == 45;
        }
        return false;
    }

    public static void render(Font font, ItemStack stack, int itemPosX, int itemPosY, float blitOffset) {
        ItemContainerProvider provider = ItemContainerProviders.INSTANCE.get(stack);
        if (provider != null) {
            ItemDecorationHelper.resetRenderState();
            DynamicItemDecorator itemDecorator = DECORATORS_CACHE.computeIfAbsent(provider, $ -> ItemDecorationHelper.getDynamicItemDecorator((screen, containerStack, carriedStack) -> {
                Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft((Screen)screen);
                return ItemDecoratorType.getItemDecoratorType(provider, containerStack, carriedStack, (Player)minecraft.f_91074_);
            }, () -> ((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).containerItemIndicator));
            if (itemDecorator.renderItemDecorations(font, stack, itemPosX, itemPosY, blitOffset)) {
                ItemDecorationHelper.resetRenderState();
            }
        }
    }

    private static void resetRenderState() {
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
    }

    public static void clearCache() {
        DECORATORS_CACHE.clear();
    }

    public static void setActiveSlot(@Nullable Slot activeSlot) {
        ItemDecorationHelper.activeSlot = activeSlot;
    }

    @FunctionalInterface
    public static interface ItemDecoratorProvider {
        public ItemDecoratorType get(AbstractContainerScreen<?> var1, ItemStack var2, ItemStack var3);
    }

    private static enum ItemDecoratorType {
        NONE("", -1),
        SPACE("+", ChatFormatting.YELLOW),
        PRESENT_AND_SPACE("+", ChatFormatting.GREEN),
        PRESENT_NO_SPACE("+", ChatFormatting.RED);

        private final String text;
        private final int color;

        private ItemDecoratorType(String text, ChatFormatting color) {
            this(text, color.m_126665_());
        }

        private ItemDecoratorType(String text, int color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public int getWidth(Font font) {
            return font.m_92895_(this.text);
        }

        public int getColor() {
            return this.color;
        }

        public static ItemDecoratorType getItemDecoratorType(ItemContainerProvider provider, ItemStack containerStack, ItemStack carriedStack, Player player) {
            if (provider.canAddItem(containerStack, carriedStack, player)) {
                if (provider.hasAnyOf(containerStack, carriedStack, player)) {
                    return PRESENT_AND_SPACE;
                }
                return SPACE;
            }
            if (provider.hasAnyOf(containerStack, carriedStack, player)) {
                return PRESENT_NO_SPACE;
            }
            return NONE;
        }
    }
}

