/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.network.client;

import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.impl.world.inventory.ContainerSlotHelper;
import fuzs.puzzleslib.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class C2SContainerClientInputMessage
implements Message<C2SContainerClientInputMessage> {
    private int currentSlot;
    private boolean extractSingleItem;

    public C2SContainerClientInputMessage() {
    }

    public C2SContainerClientInputMessage(int currentSlot, boolean extractSingleItem) {
        this.currentSlot = currentSlot;
        this.extractSingleItem = extractSingleItem;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeShort(this.currentSlot);
        buf.writeBoolean(this.extractSingleItem);
    }

    public void read(FriendlyByteBuf buf) {
        this.currentSlot = buf.readShort();
        this.extractSingleItem = buf.readBoolean();
    }

    public Message.MessageHandler<C2SContainerClientInputMessage> makeHandler() {
        return new Message.MessageHandler<C2SContainerClientInputMessage>(){

            public void handle(C2SContainerClientInputMessage message, Player player, Object gameInstance) {
                AbstractContainerMenu containerMenu = player.f_36096_;
                if (!containerMenu.m_6875_(player)) {
                    EasyShulkerBoxes.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)containerMenu);
                    return;
                }
                if (message.currentSlot >= -1) {
                    ContainerSlotHelper.setCurrentContainerSlot(player, message.currentSlot);
                } else {
                    EasyShulkerBoxes.LOGGER.warn("{} tried to set an invalid current container item slot", (Object)player);
                }
                ContainerSlotHelper.extractSingleItem(player, message.extractSingleItem);
            }
        };
    }
}

