/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.world.inventory;

import fuzs.easyshulkerboxes.impl.capability.ContainerClientInputCapability;
import fuzs.easyshulkerboxes.impl.init.ModRegistry;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;

public class ContainerSlotHelper {
    public static int findClosestSlotWithContent(SimpleContainer container, int currentContainerSlot, boolean forwards) {
        int size = container.m_6643_();
        if (currentContainerSlot == -1) {
            currentContainerSlot = size - 1;
        }
        for (int i = 1; i <= size; ++i) {
            int currentIndex = ((currentContainerSlot + (forwards ? i : -i)) % size + size) % size;
            if (container.m_8020_(currentIndex).m_41619_()) continue;
            return currentIndex;
        }
        return -1;
    }

    public static void cycleCurrentSlotBackwards(Player player, SimpleContainer container) {
        int currentContainerSlot = ContainerSlotHelper.getCurrentContainerSlot(player);
        currentContainerSlot = ContainerSlotHelper.findClosestSlotWithContent(container, currentContainerSlot, false);
        ContainerSlotHelper.setCurrentContainerSlot(player, currentContainerSlot);
    }

    public static void resetCurrentContainerSlot(Player player) {
        ContainerSlotHelper.setCurrentContainerSlot(player, -1);
    }

    public static void setCurrentContainerSlot(Player player, int slot) {
        ModRegistry.CONTAINER_SLOT_CAPABILITY.maybeGet((Object)player).ifPresent(capability -> capability.setCurrentSlot(slot));
    }

    public static void extractSingleItem(Player player, boolean singleItemOnly) {
        ModRegistry.CONTAINER_SLOT_CAPABILITY.maybeGet((Object)player).ifPresent(capability -> capability.extractSingleItem(singleItemOnly));
    }

    public static int getCurrentContainerSlot(Player player) {
        return ModRegistry.CONTAINER_SLOT_CAPABILITY.maybeGet((Object)player).map(ContainerClientInputCapability::getCurrentSlot).orElse(-1);
    }

    public static boolean extractSingleItemOnly(Player player) {
        return ModRegistry.CONTAINER_SLOT_CAPABILITY.maybeGet((Object)player).map(ContainerClientInputCapability::extractSingleItemOnly).orElse(false);
    }
}

