/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.world.item.container;

import fuzs.easyshulkerboxes.api.container.v1.ContainerItemHelper;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.impl.world.inventory.SimpleSlotContainer;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.easyshulkerboxes.mixin.accessor.BundleItemAccessor;
import java.util.function.IntFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ContainerItemHelperImpl
implements ContainerItemHelper {
    @Override
    @Nullable
    public ItemContainerProvider getItemContainerProvider(ItemStack stack) {
        return ItemContainerProviders.INSTANCE.get(stack);
    }

    @Override
    public SimpleContainer loadItemContainer(ItemStack stack, ItemContainerProvider provider, int inventorySize, boolean allowSaving, String nbtKey) {
        return this.loadItemContainer(stack, provider, items -> new SimpleSlotContainer(inventorySize), allowSaving, nbtKey);
    }

    @Override
    public SimpleContainer loadItemContainer(ItemStack stack, ItemContainerProvider provider, IntFunction<SimpleContainer> containerFactory, boolean allowSaving, String nbtKey) {
        CompoundTag tag = provider.getItemContainerData(stack);
        ListTag items = null;
        if (tag != null && tag.m_128441_(nbtKey)) {
            items = tag.m_128437_(nbtKey, 10);
        }
        SimpleContainer simpleContainer = containerFactory.apply(items != null ? items.size() : 0);
        if (items != null) {
            simpleContainer.m_7797_(items);
        }
        if (allowSaving) {
            simpleContainer.m_19164_(container -> {
                ListTag itemsTag = ((SimpleContainer)container).m_7927_();
                provider.setItemContainerData(stack, itemsTag, nbtKey);
            });
        }
        return simpleContainer;
    }

    @Override
    public int getItemWeight(ItemStack stack) {
        return BundleItemAccessor.easyshulkerboxes$getWeight(stack);
    }

    @Override
    public NonNullList<ItemStack> convertContainerToList(SimpleContainer container) {
        NonNullList items = NonNullList.m_122779_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            items.add((Object)container.m_8020_(i));
        }
        return items;
    }

    @Override
    public float[] getBackgroundColor(@Nullable DyeColor backgroundColor) {
        if (backgroundColor == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if (backgroundColor == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        return backgroundColor.m_41068_();
    }
}

