/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.integration.inmis;

import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.container.v1.ItemContainerProviderSerializers;
import fuzs.easyshulkerboxes.api.container.v1.provider.EnderChestProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.integration.inmis.InmisProvider;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public class InmisIntegration {
    private static final List<String> DISALLOWED_ITEMS = Stream.of("baby_backpack", "frayed_backpack", "plated_backpack", "gilded_backpack", "bejeweled_backpack", "blazing_backpack", "withered_backpack", "endless_backpack").map(InmisIntegration::id).map(ResourceLocation::toString).toList();

    public static void registerProviders(BiConsumer<ResourceLocation, ItemContainerProvider> consumer) {
        consumer.accept(InmisIntegration.id("baby_backpack"), InmisIntegration.provider(3, 1, DyeColor.ORANGE));
        consumer.accept(InmisIntegration.id("frayed_backpack"), InmisIntegration.provider(9, 1, DyeColor.BROWN));
        consumer.accept(InmisIntegration.id("plated_backpack"), InmisIntegration.provider(9, 2, DyeColor.WHITE));
        consumer.accept(InmisIntegration.id("gilded_backpack"), InmisIntegration.provider(9, 3, DyeColor.YELLOW));
        consumer.accept(InmisIntegration.id("bejeweled_backpack"), InmisIntegration.provider(9, 5, DyeColor.LIGHT_BLUE));
        consumer.accept(InmisIntegration.id("blazing_backpack"), InmisIntegration.provider(9, 6, DyeColor.YELLOW));
        consumer.accept(InmisIntegration.id("withered_backpack"), InmisIntegration.provider(11, 6, DyeColor.BLACK));
        consumer.accept(InmisIntegration.id("endless_backpack"), InmisIntegration.provider(15, 6, DyeColor.CYAN));
        consumer.accept(InmisIntegration.id("ender_pouch"), new EnderChestProvider());
        ItemContainerProviderSerializers.register(InmisProvider.class, EasyShulkerBoxes.id("inmis"), InmisProvider::fromJson);
    }

    private static ItemContainerProvider provider(int inventoryWidth, int inventoryHeight, @Nullable DyeColor dyeColor) {
        return new InmisProvider(inventoryWidth, inventoryHeight, dyeColor, "Inventory").disallowValues(DISALLOWED_ITEMS);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation("inmis", path);
    }
}

