/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.cookscollection.block.entity.custom;

import com.ncpbails.cookscollection.block.custom.OvenBlock;
import com.ncpbails.cookscollection.block.entity.ModBlockEntities;
import com.ncpbails.cookscollection.client.ModSounds;
import com.ncpbails.cookscollection.recipe.OvenRecipe;
import com.ncpbails.cookscollection.recipe.OvenShapedRecipe;
import com.ncpbails.cookscollection.screen.OvenMenu;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;

public class OvenBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 72;
    private int litTime = 0;
    static int countOutput = 1;
    private ContainerOpenersCounter openersCounter;
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            OvenBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public OvenBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.OVEN_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> OvenBlockEntity.this.progress;
                    case 1 -> OvenBlockEntity.this.maxProgress;
                    case 2 -> OvenBlockEntity.this.litTime;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        OvenBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        OvenBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        OvenBlockEntity.this.litTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(Level level, BlockPos pos, BlockState state) {
                OvenBlockEntity.this.playSound(state, (SoundEvent)ModSounds.OVEN_OPEN.get());
                OvenBlockEntity.this.updateBlockState(state, true);
            }

            protected void m_142289_(Level level, BlockPos pos, BlockState state) {
                OvenBlockEntity.this.playSound(state, (SoundEvent)ModSounds.OVEN_CLOSE.get());
                OvenBlockEntity.this.updateBlockState(state, false);
            }

            protected void m_142148_(Level level, BlockPos pos, BlockState state, int p_155069_, int p_155070_) {
            }

            protected boolean m_142718_(Player player) {
                if (player.f_36096_ instanceof OvenMenu) {
                    BlockEntity be = ((OvenMenu)player.f_36096_).getBlockEntity();
                    return be == OvenBlockEntity.this;
                }
                return false;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cookscollection.oven");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new OvenMenu(pContainerId, pInventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("oven.progress", this.progress);
        tag.m_128405_("oven.lit_time", this.litTime);
        tag.m_128405_("oven.max_progress", this.maxProgress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("oven.progress");
        this.litTime = nbt.m_128451_("oven.lit_time");
        this.maxProgress = nbt.m_128451_("oven.max_progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, OvenBlockEntity pBlockEntity) {
        pBlockEntity.recheckOpen();
        if (OvenBlockEntity.isFueled(pBlockEntity, pPos, pLevel)) {
            pBlockEntity.litTime = 1;
            OvenBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        } else {
            pBlockEntity.litTime = 0;
            OvenBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        if (OvenBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            OvenBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                OvenBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            OvenBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(OvenBlockEntity entity) {
        Level level = entity.f_58857_;
        BlockPos pos = entity.m_58899_();
        if (!OvenBlockEntity.isFueled(entity, pos, level)) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional shapedMatch = level.m_7465_().m_44015_((RecipeType)OvenShapedRecipe.Type.INSTANCE, (Container)inventory, level);
        Optional recipeMatch = level.m_7465_().m_44015_((RecipeType)OvenRecipe.Type.INSTANCE, (Container)inventory, level);
        if (shapedMatch.isPresent()) {
            entity.maxProgress = ((OvenShapedRecipe)shapedMatch.get()).getCookTime();
            return true;
        }
        if (recipeMatch.isPresent()) {
            entity.maxProgress = ((OvenRecipe)recipeMatch.get()).getCookTime();
            return true;
        }
        return false;
    }

    static boolean isFueled(OvenBlockEntity entity, BlockPos pos, Level level) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (!stateBelow.m_61138_((Property)BlockStateProperties.f_61443_) || ((Boolean)stateBelow.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            if (stateBelow.m_204336_(ModTags.HEAT_SOURCES) || stateBelow.m_204336_(ModTags.HEAT_CONDUCTORS)) {
                level.m_7731_(pos, (BlockState)entity.m_58900_().m_61124_((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                return true;
            }
            level.m_7731_(pos, (BlockState)entity.m_58900_().m_61124_((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            return false;
        }
        level.m_7731_(pos, (BlockState)entity.m_58900_().m_61124_((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        return false;
    }

    private static void craftItem(OvenBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional shapedMatch = level.m_7465_().m_44015_((RecipeType)OvenShapedRecipe.Type.INSTANCE, (Container)inventory, level);
        Optional recipeMatch = level.m_7465_().m_44015_((RecipeType)OvenRecipe.Type.INSTANCE, (Container)inventory, level);
        if (shapedMatch.isPresent()) {
            int i;
            for (i = 0; i < 9; ++i) {
                ItemStack slotStack = entity.itemHandler.getStackInSlot(i);
                if (!slotStack.hasCraftingRemainingItem()) continue;
                Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)OvenBlock.FACING)).m_122428_();
                double x = (double)entity.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)entity.f_58858_.m_123342_() + 0.7;
                double z = (double)entity.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                OvenBlockEntity.spawnItemEntity(entity.f_58857_, entity.itemHandler.getStackInSlot(i).getCraftingRemainingItem(), x, y, z, (float)direction.m_122429_() * 0.08f, 0.25, (float)direction.m_122431_() * 0.08f);
            }
            for (i = 0; i < 9; ++i) {
                entity.itemHandler.extractItem(i, 1, false);
            }
            inventory.m_8020_(9).m_150930_(((OvenShapedRecipe)shapedMatch.get()).m_8043_().m_41720_());
            entity.itemHandler.setStackInSlot(9, new ItemStack((ItemLike)((OvenShapedRecipe)shapedMatch.get()).m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(9).m_41613_() + entity.getTheCount(((OvenShapedRecipe)shapedMatch.get()).m_8043_())));
            entity.resetProgress();
        } else if (recipeMatch.isPresent()) {
            int i;
            for (i = 0; i < 9; ++i) {
                ItemStack slotStack = entity.itemHandler.getStackInSlot(i);
                if (!slotStack.hasCraftingRemainingItem()) continue;
                Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)OvenBlock.FACING)).m_122428_();
                double x = (double)entity.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)entity.f_58858_.m_123342_() + 0.7;
                double z = (double)entity.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                OvenBlockEntity.spawnItemEntity(entity.f_58857_, entity.itemHandler.getStackInSlot(i).getCraftingRemainingItem(), x, y, z, (float)direction.m_122429_() * 0.08f, 0.25, (float)direction.m_122431_() * 0.08f);
            }
            for (i = 0; i < 9; ++i) {
                entity.itemHandler.extractItem(i, 1, false);
            }
            inventory.m_8020_(9).m_150930_(((OvenRecipe)recipeMatch.get()).m_8043_().m_41720_());
            entity.itemHandler.setStackInSlot(9, new ItemStack((ItemLike)((OvenRecipe)recipeMatch.get()).m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(9).m_41613_() + entity.getTheCount(((OvenRecipe)recipeMatch.get()).m_8043_())));
            entity.resetProgress();
        }
    }

    public static void spawnItemEntity(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.m_20334_(xMotion, yMotion, zMotion);
        level.m_7967_((Entity)entity);
    }

    private int getTheCount(ItemStack itemIn) {
        return itemIn.m_41613_();
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)OvenBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i normal = ((Direction)state.m_61143_((Property)OvenBlock.FACING)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)normal.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)normal.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)normal.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

