/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.cookscollection.integration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ncpbails.cookscollection.block.ModBlocks;
import com.ncpbails.cookscollection.integration.JEICooksCollectionPlugin;
import com.ncpbails.cookscollection.recipe.OvenRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class OvenRecipeCategory
implements IRecipeCategory<OvenRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("cookscollection", "baking");
    public static final ResourceLocation TEXTURE = new ResourceLocation("cookscollection", "textures/gui/oven_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final int regularCookTime = 400;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public OvenRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 124, 58);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.OVEN.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(TEXTURE, 126, 0, 23, 18).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public void draw(OvenRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 63, 19);
        this.drawCookTime(recipe, poseStack, 45);
    }

    protected void drawCookTime(OvenRecipe recipe, PoseStack poseStack, int y) {
        int cookTime = recipe.getCookTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, (Component)timeString, (float)(this.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected IDrawableAnimated getArrow(OvenRecipe recipe) {
        int cookTime = recipe.getCookTime();
        if (cookTime <= 0) {
            cookTime = 400;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public RecipeType<OvenRecipe> getRecipeType() {
        return JEICooksCollectionPlugin.BAKING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"recipe.cookscollection.shapeless_baking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenRecipe recipe, IFocusGroup focuses) {
        int start = 3;
        int offset = 18;
        int offset2 = offset + offset;
        builder.addSlot(RecipeIngredientRole.INPUT, start, start).addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.m_7527_().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, start + offset, start).addIngredients((Ingredient)recipe.m_7527_().get(1));
            if (recipe.m_7527_().size() > 2) {
                builder.addSlot(RecipeIngredientRole.INPUT, start + offset2, start).addIngredients((Ingredient)recipe.m_7527_().get(2));
                if (recipe.m_7527_().size() > 3) {
                    builder.addSlot(RecipeIngredientRole.INPUT, start, start + offset).addIngredients((Ingredient)recipe.m_7527_().get(3));
                    if (recipe.m_7527_().size() > 4) {
                        builder.addSlot(RecipeIngredientRole.INPUT, start + offset, start + offset).addIngredients((Ingredient)recipe.m_7527_().get(4));
                        if (recipe.m_7527_().size() > 5) {
                            builder.addSlot(RecipeIngredientRole.INPUT, start + offset2, start + offset).addIngredients((Ingredient)recipe.m_7527_().get(5));
                            if (recipe.m_7527_().size() > 6) {
                                builder.addSlot(RecipeIngredientRole.INPUT, start, start + offset2).addIngredients((Ingredient)recipe.m_7527_().get(6));
                                if (recipe.m_7527_().size() > 7) {
                                    builder.addSlot(RecipeIngredientRole.INPUT, start + offset, start + offset2).addIngredients((Ingredient)recipe.m_7527_().get(7));
                                    if (recipe.m_7527_().size() > 8) {
                                        builder.addSlot(RecipeIngredientRole.INPUT, start + offset2, start + offset2).addIngredients((Ingredient)recipe.m_7527_().get(8));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 21).addItemStack(recipe.m_8043_());
    }
}

