/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.cookscollection.integration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ncpbails.cookscollection.block.ModBlocks;
import com.ncpbails.cookscollection.integration.JEICooksCollectionPlugin;
import com.ncpbails.cookscollection.recipe.OvenShapedRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class OvenShapedRecipeCategory
implements IRecipeCategory<OvenShapedRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("cookscollection", "baking_shaped");
    public static final ResourceLocation TEXTURE = new ResourceLocation("cookscollection", "textures/gui/oven_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final int regularCookTime = 400;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public OvenShapedRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 124, 58);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.OVEN.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(TEXTURE, 126, 0, 23, 18).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public void draw(OvenShapedRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 63, 19);
        this.drawCookTime(recipe, poseStack, 45);
    }

    protected void drawCookTime(OvenShapedRecipe recipe, PoseStack poseStack, int y) {
        int cookTime = recipe.getCookTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, (Component)timeString, (float)(this.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected IDrawableAnimated getArrow(OvenShapedRecipe recipe) {
        int cookTime = recipe.getCookTime();
        if (cookTime <= 0) {
            cookTime = 400;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public RecipeType<OvenShapedRecipe> getRecipeType() {
        return JEICooksCollectionPlugin.BAKING_SHAPED_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"recipe.cookscollection.shapeless_baking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenShapedRecipe recipe, IFocusGroup focuses) {
        int start = 3;
        int index = 0;
        for (int y = 0; y < recipe.getHeight(); ++y) {
            for (int x = 0; x < recipe.getWidth(); ++x) {
                builder.addSlot(RecipeIngredientRole.INPUT, start + x * 18, start + y * 18).addIngredients((Ingredient)recipe.m_7527_().get(index));
                ++index;
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 21).addItemStack(recipe.m_8043_());
    }
}

