/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.cookscollection.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class OvenRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final int cookTime;
    private final boolean isSimple;

    public OvenRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int cookTime) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.cookTime = cookTime;
        this.isSimple = recipeItems.stream().allMatch(Ingredient::isSimple);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        ItemStack outputSlot = pContainer.m_8020_(9);
        if (!outputSlot.m_41619_() && !ItemStack.m_41746_((ItemStack)this.m_8043_(), (ItemStack)outputSlot)) {
            return false;
        }
        if (!outputSlot.m_41619_() && outputSlot.m_41613_() >= outputSlot.m_41741_()) {
            return false;
        }
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = pContainer.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.recipeItems.size() && (this.isSimple ? stackedcontents.m_36475_((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack assemble(SimpleContainer p_44001_) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<OvenRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final ResourceLocation NAME = new ResourceLocation("cookscollection", "baking");

        public OvenRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            NonNullList<Ingredient> inputs = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputs.isEmpty()) {
                throw new JsonParseException("No ingredients for baking recipe");
            }
            if (inputs.size() > 9) {
                throw new JsonParseException("Too many ingredients for baking recipe. The maximum is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int cookTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"cooktime", (int)200);
            return new OvenRecipe(resourceLocation, itemstack, inputs, cookTimeIn);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public OvenRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int i = buf.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputs.size(); ++j) {
                inputs.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack itemstack = buf.m_130267_();
            int cookTimeIn = buf.m_130242_();
            return new OvenRecipe(id, itemstack, (NonNullList<Ingredient>)inputs, cookTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buf, OvenRecipe recipe) {
            buf.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
            buf.m_130130_(recipe.cookTime);
        }
    }

    public static class Type
    implements RecipeType<OvenRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "baking";

        private Type() {
        }
    }
}

