/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.task.launch;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import me.jellysquid.mods.lithium.common.util.collections.MaskedList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Brain.class})
public class BrainMixin<E extends LivingEntity> {
    @Shadow
    @Final
    private Map<Integer, Map<Activity, Set<Behavior<? super E>>>> f_21845_;
    @Shadow
    @Final
    private Set<Activity> f_21850_;
    private ArrayList<Behavior<? super E>> possibleTasks;
    private MaskedList<Behavior<? super E>> runningTasks;

    private void onTasksChanged() {
        this.runningTasks = null;
        this.onPossibleActivitiesChanged();
    }

    private void onPossibleActivitiesChanged() {
        this.possibleTasks = null;
    }

    private void initPossibleTasks() {
        this.possibleTasks = new ArrayList();
        for (Map<Activity, Set<Behavior<E>>> map : this.f_21845_.values()) {
            for (Map.Entry<Activity, Set<Behavior<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.f_21850_.contains(activity)) continue;
                Set<Behavior<E>> set = entry.getValue();
                for (Behavior<? super E> behavior : set) {
                    this.possibleTasks.add(behavior);
                }
            }
        }
    }

    private ArrayList<Behavior<? super E>> getPossibleTasks() {
        if (this.possibleTasks == null) {
            this.initPossibleTasks();
        }
        return this.possibleTasks;
    }

    private MaskedList<Behavior<? super E>> getCurrentlyRunningTasks() {
        if (this.runningTasks == null) {
            this.initCurrentlyRunningTasks();
        }
        return this.runningTasks;
    }

    private void initCurrentlyRunningTasks() {
        MaskedList<Behavior<? super E>> list = new MaskedList<Behavior<? super E>>(new ObjectArrayList(), false);
        for (Map<Activity, Set<Behavior<E>>> map : this.f_21845_.values()) {
            for (Set<Behavior<E>> set : map.values()) {
                for (Behavior<? super E> behavior : set) {
                    list.addOrSet(behavior, behavior.m_22536_() == Behavior.Status.RUNNING);
                }
            }
        }
        this.runningTasks = list;
    }

    @Overwrite
    private void m_21957_(ServerLevel world, E entity) {
        long startTime = world.m_46467_();
        for (Behavior<E> task : this.getPossibleTasks()) {
            if (task.m_22536_() != Behavior.Status.STOPPED) continue;
            task.m_22554_(world, entity, startTime);
        }
    }

    @Overwrite
    @Deprecated
    @VisibleForDebug
    public List<Behavior<? super E>> m_21956_() {
        return this.getCurrentlyRunningTasks();
    }

    @Inject(method={"<init>(Ljava/util/Collection;Ljava/util/Collection;Lcom/google/common/collect/ImmutableList;Ljava/util/function/Supplier;)V"}, at={@At(value="RETURN")})
    private void reinitializeBrainCollections(Collection<?> memories, Collection<?> sensors, ImmutableList<?> memoryEntries, Supplier<?> codecSupplier, CallbackInfo ci) {
        this.onTasksChanged();
    }

    @Inject(method={"setTaskList(Lnet/minecraft/entity/ai/brain/Activity;Lcom/google/common/collect/ImmutableList;Ljava/util/Set;Ljava/util/Set;)V"}, at={@At(value="RETURN")})
    private void reinitializeTasksSorted(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<?>>> indexedTasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories, Set<MemoryModuleType<?>> forgettingMemories, CallbackInfo ci) {
        this.onTasksChanged();
    }

    @Inject(method={"clear()V"}, at={@At(value="RETURN")})
    private void reinitializeTasksSorted(CallbackInfo ci) {
        this.onTasksChanged();
    }

    @Inject(method={"resetPossibleActivities(Lnet/minecraft/entity/ai/brain/Activity;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void onPossibleActivitiesChanged(Activity except, CallbackInfo ci) {
        this.onPossibleActivitiesChanged();
    }

    @Inject(method={"stopAllTasks"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/Task;stop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;J)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeStoppedTask(ServerLevel world, E entity, CallbackInfo ci, long l, Iterator<?> it, Behavior<? super E> task) {
        if (this.runningTasks != null) {
            this.runningTasks.setVisible(task, false);
        }
    }

    @Inject(method={"updateTasks"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/Task;tick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;J)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeTaskIfStopped(ServerLevel world, E entity, CallbackInfo ci, long l, Iterator<?> it, Behavior<? super E> task) {
        if (this.runningTasks != null && task.m_22536_() != Behavior.Status.RUNNING) {
            this.runningTasks.setVisible(task, false);
        }
    }

    @ModifyVariable(method={"startTasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/Task;tryStarting(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;J)Z", shift=At.Shift.AFTER))
    private Behavior<? super E> addStartedTasks(Behavior<? super E> task) {
        if (this.runningTasks != null && task.m_22536_() == Behavior.Status.RUNNING) {
            this.runningTasks.setVisible(task, true);
        }
        return task;
    }
}

