/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.collisions.unpushable_cramming;

import java.util.ArrayList;
import java.util.Iterator;
import me.jellysquid.mods.lithium.common.entity.pushable.BlockCachingEntity;
import me.jellysquid.mods.lithium.common.entity.pushable.EntityPushablePredicate;
import me.jellysquid.mods.lithium.common.entity.pushable.PushableEntityClassGroup;
import me.jellysquid.mods.lithium.common.util.collections.ReferenceMaskedList;
import me.jellysquid.mods.lithium.common.world.ClimbingMobCachingSection;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntitySection.class})
public abstract class EntityTrackingSectionMixin<T extends EntityAccess>
implements ClimbingMobCachingSection {
    @Shadow
    @Final
    private ClassInstanceMultiMap<T> f_156827_;
    @Shadow
    private Visibility f_156828_;
    @Unique
    private ReferenceMaskedList<Entity> pushableEntities;

    @Override
    public void collectPushableEntities(Level world, Entity except, AABB box, EntityPushablePredicate<? super Entity> entityPushablePredicate, ArrayList<Entity> entities) {
        Iterator entityIterator = this.pushableEntities != null ? this.pushableEntities.iterator() : this.f_156827_.iterator();
        int i = 0;
        int j = 0;
        while (entityIterator.hasNext()) {
            Entity entity = (Entity)entityIterator.next();
            if (!entity.m_20191_().m_82381_(box) || entity.m_5833_() || entity == except || entity instanceof EnderDragon) continue;
            ++i;
            if (!entityPushablePredicate.test(entity)) continue;
            ++j;
            entities.add(entity);
        }
        if (this.pushableEntities == null && i >= 25 && i >= j * 2) {
            this.startFilteringPushableEntities();
        }
    }

    private void startFilteringPushableEntities() {
        this.pushableEntities = new ReferenceMaskedList();
        for (EntityAccess entity : this.f_156827_) {
            this.onStartClimbingCachingEntity((Entity)entity);
        }
    }

    private void stopFilteringPushableEntities() {
        this.pushableEntities = null;
    }

    @Override
    public void onEntityModifiedCachedBlock(BlockCachingEntity entity, BlockState newBlockState) {
        if (this.pushableEntities == null) {
            entity.lithiumSetClimbingMobCachingSectionUpdateBehavior(false);
        } else {
            this.updatePushabilityOnCachedStateChange(entity, newBlockState);
        }
    }

    private void updatePushabilityOnCachedStateChange(BlockCachingEntity entity, BlockState newBlockState) {
        boolean visible = EntityTrackingSectionMixin.entityPushableHeuristic(newBlockState);
        this.pushableEntities.setVisible((Entity)entity, visible);
    }

    private void onStartClimbingCachingEntity(Entity entity) {
        Class<?> entityClass = entity.getClass();
        if (PushableEntityClassGroup.MAYBE_PUSHABLE.contains(entityClass)) {
            this.pushableEntities.add(entity);
            boolean shouldTrackBlockChanges = PushableEntityClassGroup.CACHABLE_UNPUSHABILITY.contains(entityClass);
            if (shouldTrackBlockChanges) {
                BlockCachingEntity blockCachingEntity = (BlockCachingEntity)entity;
                this.updatePushabilityOnCachedStateChange(blockCachingEntity, blockCachingEntity.getCachedFeetBlockState());
                blockCachingEntity.lithiumSetClimbingMobCachingSectionUpdateBehavior(true);
            }
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/entity/EntityLike;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (this.pushableEntities != null) {
            if (!this.f_156828_.m_157694_()) {
                this.stopFilteringPushableEntities();
            } else {
                this.onStartClimbingCachingEntity((Entity)entityLike);
                if (this.pushableEntities.totalSize() > this.f_156827_.size()) {
                    this.stopFilteringPushableEntities();
                }
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/EntityLike;)Z"}, at={@At(value="RETURN")})
    private void onEntityRemoved(T entityLike, CallbackInfoReturnable<Boolean> cir) {
        if (this.pushableEntities != null) {
            if (!this.f_156828_.m_157694_()) {
                this.stopFilteringPushableEntities();
            } else {
                this.pushableEntities.remove((Entity)entityLike);
            }
        }
    }

    private static boolean entityPushableHeuristic(BlockState cachedFeetBlockState) {
        return cachedFeetBlockState == null || !cachedFeetBlockState.m_204336_(BlockTags.f_13082_);
    }
}

