/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.venturecraft.gliders.client.model.GliderModel;
import net.venturecraft.gliders.client.model.ModelRegistry;
import net.venturecraft.gliders.client.model.XWingModel;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.util.GliderUtil;

public class PlayerGliderLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation COPPER_EMBED = new ResourceLocation("vc_gliders", "textures/entity/glider/copper_overlay.png");
    private static final ResourceLocation NETHER_UPGRADE = new ResourceLocation("vc_gliders", "textures/entity/glider/nether_upgrade_overlay.png");
    private static final ResourceLocation COPPER_EMBED_CHARGED = new ResourceLocation("vc_gliders", "textures/entity/glider/copper_overlay_charged.png");
    private static final ResourceLocation XWING_TEXTURE = new ResourceLocation("vc_gliders", "textures/entity/glider/xwing.png");
    public static GliderModel gliderModel;
    public static XWingModel<Entity> xWingModel;

    public PlayerGliderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        gliderModel = new GliderModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelRegistry.GLIDER));
        xWingModel = new XWingModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelRegistry.X_WING));
    }

    public static ResourceLocation getGliderTexture(ItemStack stack) {
        if (stack.m_41611_().getString().contains("xwing")) {
            return XWING_TEXTURE;
        }
        ResourceLocation itemLoc = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
        return new ResourceLocation(itemLoc.m_135827_(), "textures/entity/glider/" + itemLoc.m_135815_() + ".png");
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int p_117351_, T living, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        if (living.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        ItemStack stack = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)living);
        if (GliderUtil.isGlidingWithActiveGlider(living)) {
            poseStack.m_85836_();
            if (stack.m_41611_().getString().contains("xwing")) {
                poseStack.m_85837_(0.0, -1.9, -0.5);
                xWingModel.m_6973_((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).f_19797_, 0.0f, 0.0f);
                xWingModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), p_117351_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                poseStack.m_85837_(0.0, -1.8, 0.0);
                gliderModel.m_6973_((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).f_19797_, 0.0f, 0.0f);
                gliderModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), p_117351_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                if (GliderItem.hasCopperUpgrade(stack)) {
                    gliderModel.m_6973_((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).f_19797_, 0.0f, 0.0f);
                    gliderModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)(GliderItem.hasBeenStruck(stack) ? COPPER_EMBED_CHARGED : COPPER_EMBED))), p_117351_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (GliderItem.hasNetherUpgrade(stack)) {
                    gliderModel.m_6973_((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).f_19797_, 0.0f, 0.0f);
                    gliderModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)NETHER_UPGRADE)), p_117351_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            poseStack.m_85849_();
        }
    }
}

