/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladiumcore.event.EntityEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.venturecraft.gliders.common.GliderDamageSource;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;

public class GliderEvents
implements LivingEntityEvents.Attack,
PlayerEvents.Tracking,
LivingEntityEvents.Tick,
EntityEvents.LightningStrike,
LivingEntityEvents.Hurt,
PlayerEvents.AnvilUpdate {
    public static void initEvents() {
        GliderEvents instance = new GliderEvents();
        EntityEvents.LIGHTNING_STRIKE.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        PlayerEvents.ANVIL_UPDATE.register((Object)instance);
        PlayerEvents.START_TRACKING.register((Object)instance);
        LivingEntityEvents.TICK.register((Object)instance);
    }

    public void lightningStrike(List<Entity> entities, LightningBolt lightningBolt) {
        for (Entity entity : entities) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
            if (!hasCopperMod && isGliding) {
                GliderItem.setBroken(chestItem, true);
                return;
            }
            if (!hasCopperMod || !isGliding) continue;
            GliderItem.setStruck(chestItem, true);
            if (!GliderItem.hasBeenStruck(chestItem)) continue;
            player.m_6469_((DamageSource)GliderDamageSource.BAD_LIGHTNING_EXPERIMENT, 2.0f);
        }
    }

    public EventResult anvilUpdate(Player player, ItemStack left, ItemStack right, String name, AtomicInteger cost, AtomicInteger materialCost, AtomicReference<ItemStack> output) {
        GliderItem gliderItem;
        Item item = left.m_41720_();
        if (item instanceof GliderItem && (gliderItem = (GliderItem)item).m_6832_(left, right)) {
            ItemStack data = left.m_41777_();
            GliderItem.setBroken(data, false);
            cost.set(5);
            data.m_41721_(0);
            data.m_41742_(5);
            output.set(data);
        }
        return EventResult.pass();
    }

    public void livingEntityTick(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GliderData.get((LivingEntity)player).ifPresent(data -> data.tick((LivingEntity)player));
        }
    }

    public void playerTracking(Player tracker, Entity trackedEntity) {
        if (trackedEntity instanceof Player) {
            Player trackedPlayer = (Player)trackedEntity;
            if (tracker instanceof ServerPlayer) {
                ServerPlayer trackerPlayer = (ServerPlayer)tracker;
                GliderData.get((LivingEntity)trackedPlayer).ifPresent(data -> data.syncTo(trackerPlayer));
            }
        }
    }

    public EventResult livingEntityHurt(LivingEntity entity, DamageSource damageSource, AtomicReference<Float> amount) {
        if (entity instanceof Player) {
            boolean isLightning;
            Player player = (Player)entity;
            ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
            boolean bl = isLightning = damageSource == DamageSource.f_19306_;
            if (hasCopperMod && isGliding && isLightning) {
                return EventResult.cancel();
            }
        }
        return EventResult.pass();
    }

    public EventResult livingEntityAttack(LivingEntity entity, DamageSource damageSource, float amount) {
        Entity entity2 = damageSource.m_7640_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            return GliderUtil.isGlidingWithActiveGlider(livingEntity) ? EventResult.cancel() : EventResult.pass();
        }
        return EventResult.pass();
    }
}

