/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.venturecraft.gliders.common.recipe.RecipeSerializerRegistry;

public class GliderUpgradingRecipe
extends UpgradeRecipe {
    private final Ingredient base;
    private final Ingredient addition;
    private final String upgrade;

    public GliderUpgradingRecipe(ResourceLocation resourceLocation, Ingredient base, Ingredient addition, String upgrade) {
        super(resourceLocation, base, addition, ItemStack.f_41583_);
        this.base = base;
        this.addition = addition;
        this.upgrade = upgrade;
    }

    public static ItemStack makeResult(ItemStack base, String upgrade) {
        ItemStack result = base.m_41777_();
        result.m_41784_().m_128379_(upgrade + "_upgrade", true);
        return result;
    }

    public ItemStack m_5874_(Container container) {
        return GliderUpgradingRecipe.makeResult(container.m_8020_(0), this.upgrade);
    }

    public ItemStack m_8043_() {
        return GliderUpgradingRecipe.makeResult(this.base.m_43908_()[0], this.upgrade);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.GLIDER_UPGRADING.get();
    }

    public static class Serializer
    implements RecipeSerializer<GliderUpgradingRecipe> {
        public GliderUpgradingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            String upgrade = GsonHelper.m_13906_((JsonObject)json, (String)"upgrade");
            return new GliderUpgradingRecipe(recipeId, base, addition, upgrade);
        }

        public GliderUpgradingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String upgrade = buffer.m_130277_();
            return new GliderUpgradingRecipe(recipeId, base, addition, upgrade);
        }

        public void toNetwork(FriendlyByteBuf buffer, GliderUpgradingRecipe recipe) {
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130070_(recipe.upgrade);
        }
    }
}

