/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.forge.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.data.LanguageProvider;
import net.venturecraft.gliders.common.GliderDamageSource;
import net.venturecraft.gliders.common.item.ItemRegistry;
import net.venturecraft.gliders.common.sound.SoundRegistry;
import net.venturecraft.gliders.util.ModConstants;

public class EnglishLangProvider
extends LanguageProvider {
    public EnglishLangProvider(DataGenerator gen) {
        super(gen, "vc_gliders", "en_us");
    }

    protected void addTranslations() {
        this.add((Item)ItemRegistry.PARAGLIDER_WOOD.get(), "Basic Paraglider");
        this.add((Item)ItemRegistry.PARAGLIDER_IRON.get(), "Iron Paraglider");
        this.add((Item)ItemRegistry.PARAGLIDER_DIAMOND.get(), "Diamond Paraglider");
        this.add((Item)ItemRegistry.PARAGLIDER_GOLD.get(), "Gold Paraglider");
        this.add((Item)ItemRegistry.PARAGLIDER_NETHERITE.get(), "Netherite Paraglider");
        this.add((Item)ItemRegistry.REINFORCED_PAPER.get(), "Re-Inforced Paper");
        this.add((Item)ItemRegistry.REINFORCED_PAPER_IRON.get(), "Re-Inforced Paper (Iron)");
        this.add((Item)ItemRegistry.REINFORCED_PAPER_GOLD.get(), "Re-Inforced Paper (Gold)");
        this.add((Item)ItemRegistry.REINFORCED_PAPER_DIAMOND.get(), "Re-Inforced Paper (Diamond)");
        this.add((Item)ItemRegistry.REINFORCED_PAPER_NETHERITE.get(), "Re-Inforced Paper (Netherite)");
        this.add((Item)ItemRegistry.COPPER_UPGRADE.get(), Rarity.UNCOMMON.f_43022_ + "Copper Upgrade");
        this.add((Item)ItemRegistry.NETHER_UPGRADE.get(), Rarity.EPIC.f_43022_ + "Nether Upgrade");
        this.add(ModConstants.NETHER_UPGRADE, Rarity.EPIC.f_43022_ + "Nether Upgrade");
        this.add(ModConstants.COPPER_UPGRADE, Rarity.UNCOMMON.f_43022_ + "Copper Upgrade");
        this.add(ModConstants.INSTALLED_UPGRADES, "Installed Upgrades:");
        this.addSound((SoundEvent)SoundRegistry.GLIDER_OPEN.get(), "Glider opens");
        this.addSound((SoundEvent)SoundRegistry.SPACE_GLIDE.get(), "Space Glide");
        this.addSound((SoundEvent)SoundRegistry.SPACE_DEPLOY.get(), "Space Deploy");
        this.addSound((SoundEvent)SoundRegistry.INCOMING_LIGHTNING.get(), "Incoming Lightning");
        this.add("itemGroup.vc_gliders", "VentureCraft - Gliders");
        this.add("itemGroup.vc_gliders.main", "VentureCraft - Gliders");
        this.add("options.glider_perspective", "Glider Perspective");
        this.add("curios.identifier.glider", "Glider");
        this.addDamageSource(GliderDamageSource.BAD_LIGHTNING_EXPERIMENT, "&s was killed by a bad lightning experiment");
    }

    public void addDamageSource(GliderDamageSource gliderDamageSource, String translation) {
        this.add("dmg.vc_gliders." + gliderDamageSource.getTranslationKey(), translation);
    }

    private void addSound(SoundEvent soundEvent, String subtitle) {
        this.add("subtitle.vc_gliders." + soundEvent.m_11660_().m_135815_(), subtitle);
    }
}

