/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.forge.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.venturecraft.gliders.common.recipe.RecipeSerializerRegistry;
import org.jetbrains.annotations.Nullable;

public class GliderUpgradingRecipeBuilder {
    private final Ingredient base;
    private final Ingredient addition;
    private final String upgrade;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public GliderUpgradingRecipeBuilder(Ingredient base, Ingredient addition, String upgrade) {
        this.base = base;
        this.addition = addition;
        this.upgrade = upgrade;
    }

    public GliderUpgradingRecipeBuilder unlocks(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipeConsumer, String id) {
        this.save(finishedRecipeConsumer, new ResourceLocation(id));
    }

    public void save(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(new Result(id, this.base, this.addition, this.upgrade, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/glider_upgrading/" + id.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient base;
        private final Ingredient addition;
        private final String upgrade;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation resourceLocation, Ingredient ingredient, Ingredient ingredient2, String upgrade, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.id = resourceLocation;
            this.base = ingredient;
            this.addition = ingredient2;
            this.upgrade = upgrade;
            this.advancement = builder;
            this.advancementId = resourceLocation2;
        }

        public void m_7917_(JsonObject json) {
            json.add("base", this.base.m_43942_());
            json.add("addition", this.addition.m_43942_());
            json.addProperty("upgrade", this.upgrade);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.GLIDER_UPGRADING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

