/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.venturecraft.gliders.VCGlidersClient;
import net.venturecraft.gliders.client.sound.MovingSound;
import net.venturecraft.gliders.util.GliderUtil;
import net.venturecraft.gliders.util.VCGliderTags;
import net.venturecraft.gliders.util.forge.ClientUtilImpl;

public class ClientUtil {
    public static boolean shouldChangePerspective = true;
    public static CameraType backupPerspective = Minecraft.m_91087_().f_91066_.m_92176_();

    public static void playPositionedSoundRecord(SoundEvent sound, float pitch, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void updraftParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (GliderUtil.isGlidingWithActiveGlider((LivingEntity)Minecraft.m_91087_().f_91074_) && state.m_204336_(VCGliderTags.UPDRAFT_BLOCKS)) {
            level.m_6485_((ParticleOptions)ParticleTypes.f_175821_, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 1.0, 0.0);
        }
    }

    public static void playGliderSound(Player player, ResourceLocation soundName, SoundSource category, boolean repeat, Supplier<Boolean> stopCondition, float volume, RandomSource randomSource) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new MovingSound(player, new SoundEvent(soundName), category, repeat, stopCondition, volume, randomSource));
    }

    public static void createToast(MutableComponent title, MutableComponent subtitle) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)title, (Component)subtitle));
    }

    public static void povButton(ControlsScreen controlsScreen) {
        int i = controlsScreen.f_96543_ / 2 - 155;
        int j = i + 160;
        int k = controlsScreen.f_96544_ / 6 - 12 + 48;
        controlsScreen.m_142416_((GuiEventListener)VCGlidersClient.autoPerspective.m_231507_(Minecraft.m_91087_().f_91066_, j, k, 150));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addPredicate(Item item, ResourceLocation resourceLocation, ClampedItemPropertyFunction clampedItemPropertyFunction) {
        void var2_2;
        void var1_1;
        ClientUtilImpl.addPredicate(item, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    public static void setPlayerPerspective(String pointOfView) {
        if (((Boolean)VCGlidersClient.autoPerspective.m_231551_()).booleanValue() && !pointOfView.isEmpty()) {
            backupPerspective = Minecraft.m_91087_().f_91066_.m_92176_();
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.valueOf((String)pointOfView));
            return;
        }
        if (backupPerspective != null) {
            Minecraft.m_91087_().f_91066_.m_92157_(backupPerspective);
            backupPerspective = null;
        }
    }
}

