/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.InfoOverlay;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DrawOverlay
extends GuiComponent {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void fillGradient(Matrix4f matrix, BufferBuilder buf, int x, int y, int w, int h, int start, int end) {
        DrawOverlay.m_93123_((Matrix4f)matrix, (BufferBuilder)buf, (int)x, (int)y, (int)w, (int)h, (int)400, (int)start, (int)end);
    }

    public static void drawGUI(PoseStack poseStack, HitResult result, List<InfoOverlay.TooltipInfo> tooltipList, int rectangleX, int rectangleY, int rectangleWidth, int rectangleHeight) {
        poseStack.m_85836_();
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        DrawOverlay.drawRect(matrix4f, rectangleX, rectangleY, rectangleWidth, rectangleHeight);
        int yOffset = rectangleY;
        if (result instanceof BlockHitResult) {
            DrawOverlay.renderStack(((InfoOverlay.BlockInfo)tooltipList.get(0)).getBlock(), null, rectangleX, rectangleY + rectangleHeight / 2 - 8);
        }
        for (InfoOverlay.TooltipInfo info : tooltipList) {
            if (info instanceof InfoOverlay.MobInfo) {
                InfoOverlay.MobInfo infoLine = (InfoOverlay.MobInfo)info;
                InfoOverlay.Icon icon = infoLine.getIcon();
                ClientTooltipComponent tooltip = infoLine.getTooltip();
                if (icon != InfoOverlay.Icon.NONE) {
                    DrawOverlay.renderIcon(rectangleX, yOffset, icon.ICON_X, icon.ICON_Y, 8, 8, icon.ICON_WIDTH, icon.ICON_HEIGHT);
                }
                DrawOverlay.renderText(matrix4f, tooltip, rectangleX + icon.ICON_WIDTH + 1, yOffset);
            }
            if (info instanceof InfoOverlay.BlockInfo) {
                InfoOverlay.BlockInfo blockInfo = (InfoOverlay.BlockInfo)info;
                ClientTooltipComponent tooltip = blockInfo.getTooltip();
                if (tooltipList.size() == 1) {
                    int n = yOffset + rectangleHeight / 2;
                    Objects.requireNonNull(DrawOverlay.CLIENT.f_91062_);
                    DrawOverlay.renderText(matrix4f, tooltip, rectangleX + 18, n - 9 / 2);
                } else {
                    DrawOverlay.renderText(matrix4f, tooltip, rectangleX + 18, yOffset);
                }
            }
            yOffset += info.getHeight();
        }
        poseStack.m_85837_(0.0, 0.0, 400.0);
        poseStack.m_85849_();
    }

    public static void renderText(Matrix4f matrix4f, ClientTooltipComponent component, int textX, int textY) {
        MultiBufferSource.BufferSource multiBufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        component.m_142440_(Minecraft.m_91087_().f_91062_, textX, textY, matrix4f, multiBufferSource);
        multiBufferSource.m_109911_();
    }

    public static void renderIcon(int x, int y, int texX, int texY, int width, int height, int iconWidth, int iconHeight) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderSystem.m_69482_();
        buffer.m_5483_((double)x, (double)(y + height), (double)zLevel).m_7421_((float)texX * f, (float)(texY + iconHeight) * f1).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_((float)(texX + iconWidth) * f, (float)(texY + iconHeight) * f1).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)zLevel).m_7421_((float)(texX + iconWidth) * f, (float)texY * f1).m_5752_();
        buffer.m_5483_((double)x, (double)y, (double)zLevel).m_7421_((float)texX * f, (float)texY * f1).m_5752_();
        RenderSystem.m_69465_();
        buffer.m_5752_();
        tesselator.m_85914_();
    }

    public static void renderStack(ItemStack stack, String countText, int x, int y) {
        Lighting.m_84931_();
        RenderSystem.m_69482_();
        CLIENT.m_91291_().m_115123_(stack, x, y);
        CLIENT.m_91291_().m_115174_(DrawOverlay.CLIENT.f_91062_, stack, x, y, countText);
        Lighting.m_84930_();
        RenderSystem.m_69465_();
    }

    public static void drawRect(Matrix4f matrix4f, int rectX, int rectY, int rectW, int rectH) {
        int rectGradient = -267386864;
        int borderGrad1 = 0x505000FF;
        int borderGrad2 = 1344798847;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY - 4, rectX + rectW + 3, rectY - 3, rectGradient, rectGradient);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY + rectH + 3, rectX + rectW + 3, rectY + rectH + 4, rectGradient, rectGradient);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY - 3, rectX + rectW + 3, rectY + rectH + 3, rectGradient, rectGradient);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 4, rectY - 3, rectX - 3, rectY + rectH + 3, rectGradient, rectGradient);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX + rectW + 3, rectY - 3, rectX + rectW + 4, rectY + rectH + 3, rectGradient, rectGradient);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY - 3 + 1, rectX - 3 + 1, rectY + rectH + 3 - 1, borderGrad1, borderGrad2);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX + rectW + 2, rectY - 3 + 1, rectX + rectW + 3, rectY + rectH + 3 - 1, borderGrad1, borderGrad2);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY - 3, rectX + rectW + 3, rectY - 3 + 1, borderGrad1, borderGrad1);
        DrawOverlay.fillGradient(matrix4f, buffer, rectX - 3, rectY + rectH + 2, rectX + rectW + 3, rectY + rectH + 3, borderGrad2, borderGrad2);
        buffer.m_5752_();
        tesselator.m_85914_();
    }
}

