/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.DrawOverlay;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="usefulspyglass", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class InfoOverlay {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static HitResult hitResult = null;
    private static List<TooltipInfo> tooltipList;
    private static int rectangleWidth;
    private static int rectangleHeight;
    private static int rectangleX;
    private static int rectangleY;

    @SubscribeEvent
    public static void registerGUI(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.DEBUG_TEXT.id(), "hud_base", (gui, poseStack, partialTick, width, height) -> {
            gui.setupOverlayRenderState(true, false);
            if (hitResult != null) {
                DrawOverlay.drawGUI(poseStack, hitResult, tooltipList, rectangleX, rectangleY, rectangleWidth, rectangleHeight);
            }
        });
    }

    private static void setComponent(List<TooltipInfo> list) {
        tooltipList = list;
        rectangleWidth = InfoOverlay.getLongest(tooltipList);
        rectangleHeight = 0;
        for (TooltipInfo tooltip : tooltipList) {
            rectangleHeight += tooltip.getHeight() + (hitResult instanceof BlockHitResult && tooltipList.size() == 1 ? 16 - tooltip.getHeight() : 0);
        }
        rectangleX = (int)((double)CLIENT.m_91268_().m_85445_() * 0.09 - (double)rectangleWidth * 0.5) + 1;
        rectangleY = (int)((double)CLIENT.m_91268_().m_85446_() * 0.09);
    }

    public static void setHitResult(HitResult result) {
        EntityHitResult entityHit;
        hitResult = result;
        if (hitResult == null) {
            return;
        }
        ArrayList<TooltipInfo> array = new ArrayList<TooltipInfo>();
        HitResult hitResult = InfoOverlay.hitResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hitResult;
            MutableComponent mobRelation = entity instanceof NeutralMob || entity instanceof Player ? Component.m_237115_((String)"text.usefulspyglass.neutral").m_130940_(ChatFormatting.YELLOW) : (entity.m_6095_().m_20674_().m_21609_() ? Component.m_237115_((String)"text.usefulspyglass.friendly").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"text.usefulspyglass.hostile").m_130940_(ChatFormatting.RED));
            array.add(new MobInfo(Icon.NONE, ClientTooltipComponent.m_169948_((FormattedCharSequence)entity.m_5446_().m_7532_())));
            array.add(new MobInfo(Icon.NONE, ClientTooltipComponent.m_169948_((FormattedCharSequence)mobRelation.m_7532_())));
            array.add(new MobInfo(Icon.HEALTH, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)("x " + (int)entity.m_21223_())).m_7532_())));
            if (entity.m_21230_() > 0) {
                array.add(new MobInfo(Icon.ARMOR, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)("x " + entity.m_21230_())).m_7532_())));
            }
            InfoOverlay.setComponent(array);
            InfoOverlay.hitResult = result;
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            BlockState state = InfoOverlay.CLIENT.f_91074_.f_19853_.m_8055_(blockHit.m_82425_());
            ItemStack stack = state.m_60734_().getCloneItemStack(state, (HitResult)blockHit, (BlockGetter)InfoOverlay.CLIENT.f_91074_.f_19853_, blockHit.m_82425_(), (Player)InfoOverlay.CLIENT.f_91074_);
            String displayStr = state.m_60734_().m_49954_().getString();
            String[] arr = displayStr.split(" +");
            if (arr.length > 1) {
                int maxLength = Minecraft.m_91087_().m_91268_().m_85445_() / 6 - 18;
                StringBuilder str = new StringBuilder();
                for (String addStr : arr) {
                    if (ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)(str + " " + addStr)).m_7532_()).m_142069_(InfoOverlay.CLIENT.f_91062_) > maxLength && str.length() > 0) {
                        array.add(new BlockInfo(stack, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_7532_())));
                        str = new StringBuilder();
                    }
                    if (str.length() > 0) {
                        str.append(" ");
                    }
                    str.append(addStr);
                }
                array.add(new BlockInfo(stack, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_7532_())));
            } else {
                array.add(new BlockInfo(stack, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)displayStr).m_7532_())));
            }
            InfoOverlay.setComponent(array);
            InfoOverlay.hitResult = result;
        }
    }

    public static int getLongest(List<TooltipInfo> list) {
        int result = 0;
        for (TooltipInfo tooltip : list) {
            result = Math.max(tooltip.getWidth(), result);
        }
        return result;
    }

    public static abstract class TooltipInfo {
        abstract int getWidth();

        abstract int getHeight();
    }

    public static class MobInfo
    extends TooltipInfo {
        private final Icon icon;
        private final ClientTooltipComponent tooltip;

        public MobInfo(Icon icon, ClientTooltipComponent tooltip) {
            this.icon = icon;
            this.tooltip = tooltip;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public ClientTooltipComponent getTooltip() {
            return this.tooltip;
        }

        @Override
        public int getWidth() {
            return this.icon.ICON_WIDTH + this.tooltip.m_142069_(Minecraft.m_91087_().f_91062_);
        }

        @Override
        public int getHeight() {
            return this.tooltip.m_142103_();
        }
    }

    static enum Icon {
        NONE(0, 0, 0, 0),
        HEALTH(52, 0, 9, 9),
        ARMOR(43, 9, 9, 9);

        public final int ICON_X;
        public final int ICON_Y;
        public final int ICON_WIDTH;
        public final int ICON_HEIGHT;

        private Icon(int iconX, int iconY, int iconWidth, int iconHeight) {
            this.ICON_X = iconX;
            this.ICON_Y = iconY;
            this.ICON_WIDTH = iconWidth;
            this.ICON_HEIGHT = iconHeight;
        }
    }

    public static class BlockInfo
    extends TooltipInfo {
        private final ItemStack block;
        private final ClientTooltipComponent tooltip;

        public BlockInfo(ItemStack block, ClientTooltipComponent tooltip) {
            this.block = block;
            this.tooltip = tooltip;
        }

        public ItemStack getBlock() {
            return this.block;
        }

        public ClientTooltipComponent getTooltip() {
            return this.tooltip;
        }

        @Override
        int getWidth() {
            return 18 + this.tooltip.m_142069_(Minecraft.m_91087_().f_91062_);
        }

        @Override
        int getHeight() {
            return this.tooltip.m_142103_();
        }
    }
}

