/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass.network.packet;

import com.brokenkeyboard.usefulspyglass.UsefulSpyglass;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.network.NetworkEvent;

public class MarkEntityPacket {
    private final int entityID;
    private final ResourceLocation dimension;

    public MarkEntityPacket(int entityID, ResourceLocation dimension) {
        this.entityID = entityID;
        this.dimension = dimension;
    }

    public MarkEntityPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.dimension = buf.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130085_(this.dimension);
    }

    public static void handle(MarkEntityPacket packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            LivingEntity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = (LivingEntity)player.m_9236_().m_6815_(packet.entityID)) != null && entity.m_9236_().m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)packet.dimension))) {
                ItemStack stack = player.m_21120_(player.m_7655_());
                int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)UsefulSpyglass.MARKING.get()), (ItemStack)stack);
                entity.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19619_, 80 + (40 * level - 1), 0)));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

